/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.packaging.PyPackage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRequirement {
    private static final Pattern NAME = Pattern.compile("\\s*(\\w(\\w|[-.])*)\\s*(.*)");
    private static final Pattern VERSION_SPEC = Pattern.compile("\\s*(<=?|>=?|==|!=)\\s*((\\w|[-.])+)");
    private static final Pattern EDITABLE_EGG = Pattern.compile("\\s*(-e)?\\s*([^#]*)(#egg=(.*))?");
    private static final Pattern RECURSIVE_REQUIREMENT = Pattern.compile("\\s*-r\\s+(.*)");
    private static final Pattern VCS_PATH = Pattern.compile(".*/([^/]+)/?");
    @NotNull
    private final String myName;
    @NotNull
    private final List<VersionSpec> myVersionSpecs;
    @Nullable
    private final String myURL;
    private final boolean myEditable;

    public PyRequirement(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        this(name, Collections.emptyList());
    }

    public PyRequirement(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        this(name, Collections.singletonList(new VersionSpec(Relation.EQ, version)));
    }

    public PyRequirement(@NotNull String name, @NotNull List<VersionSpec> versionSpecs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        if (versionSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionSpecs", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        this.myName = name;
        this.myVersionSpecs = versionSpecs;
        this.myURL = null;
        this.myEditable = false;
    }

    public PyRequirement(@NotNull String name, @Nullable String version, @NotNull String url, boolean editable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/python/packaging/PyRequirement", "<init>"));
        }
        this.myName = name;
        this.myVersionSpecs = version != null ? Collections.singletonList(new VersionSpec(Relation.EQ, version)) : Collections.emptyList();
        this.myURL = url;
        this.myEditable = editable;
    }

    @NotNull
    public String toString() {
        String string = this.myName + StringUtil.join(this.myVersionSpecs, (Function)new Function<VersionSpec, String>(){

            public String fun(VersionSpec spec) {
                return spec.toString();
            }
        }, (String)",");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "toString"));
        }
        return string;
    }

    @NotNull
    public List<String> toOptions() {
        ArrayList<String> results = new ArrayList<String>();
        if (this.myEditable) {
            results.add("-e");
        }
        if (this.myURL != null) {
            int size = this.myVersionSpecs.size();
            assert (size <= 1);
            String urlAndName = this.myURL + "#egg=" + this.myName;
            if (size == 0) {
                results.add(urlAndName);
            } else {
                VersionSpec versionSpec = this.myVersionSpecs.get(0);
                assert (versionSpec.getRelation() == Relation.EQ);
                results.add(urlAndName + "-" + versionSpec.getVersion());
            }
            ArrayList<String> arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "toOptions"));
            }
            return arrayList;
        }
        results.add(this.toString());
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "toOptions"));
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyRequirement that = (PyRequirement)o;
        if (this.myEditable != that.myEditable) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (this.myURL != null ? !this.myURL.equals(that.myURL) : that.myURL != null) {
            return false;
        }
        return ((Object)this.myVersionSpecs).equals(that.myVersionSpecs);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + ((Object)this.myVersionSpecs).hashCode();
        result = 31 * result + (this.myURL != null ? this.myURL.hashCode() : 0);
        result = 31 * result + (this.myEditable ? 1 : 0);
        return result;
    }

    @Nullable
    public PyPackage match(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyRequirement", "match"));
        }
        for (PyPackage pkg : packages) {
            if (!PyRequirement.normalizeName(this.myName).equalsIgnoreCase(pkg.getName())) continue;
            for (VersionSpec spec : this.myVersionSpecs) {
                int cmp = PackageVersionComparator.VERSION_COMPARATOR.compare(pkg.getVersion(), spec.getVersion());
                Relation relation = spec.getRelation();
                if (relation.isSuccessful(cmp)) continue;
                return null;
            }
            return pkg;
        }
        return null;
    }

    @NotNull
    public static PyRequirement fromStringGuaranteed(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/packaging/PyRequirement", "fromStringGuaranteed"));
        }
        PyRequirement requirement = PyRequirement.fromString(line);
        if (requirement == null) {
            throw new IllegalArgumentException("Failed to parse " + line);
        }
        PyRequirement pyRequirement = requirement;
        if (pyRequirement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "fromStringGuaranteed"));
        }
        return pyRequirement;
    }

    @Nullable
    public static PyRequirement fromString(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/packaging/PyRequirement", "fromString"));
        }
        PyRequirement editableEgg = PyRequirement.parseEditableEgg(line);
        if (editableEgg != null) {
            return editableEgg;
        }
        Matcher nameMatcher = NAME.matcher(line);
        if (!nameMatcher.matches()) {
            return null;
        }
        String name = nameMatcher.group(1);
        String rest = nameMatcher.group(3);
        ArrayList<VersionSpec> versionSpecs = new ArrayList<VersionSpec>();
        if (!rest.trim().isEmpty()) {
            Matcher versionSpecMatcher = VERSION_SPEC.matcher(rest);
            while (versionSpecMatcher.find()) {
                String rel = versionSpecMatcher.group(1);
                String version = versionSpecMatcher.group(2);
                Relation relation = Relation.fromString(rel);
                if (relation == null) {
                    return null;
                }
                versionSpecs.add(new VersionSpec(relation, version));
            }
        }
        return new PyRequirement(name, versionSpecs);
    }

    @NotNull
    public static List<PyRequirement> parse(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        List<PyRequirement> list = PyRequirement.parse(s, null, new HashSet<VirtualFile>());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        return list;
    }

    @NotNull
    public static List<PyRequirement> parse(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        List<PyRequirement> list = PyRequirement.parse(file, new HashSet<VirtualFile>());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        return list;
    }

    @NotNull
    public static List<PyRequirement> parse(@NotNull VirtualFile file, @NotNull Set<VirtualFile> visited) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        if (!visited.contains(file)) {
            visited.add(file);
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                List<PyRequirement> list = PyRequirement.parse(document.getText(), file, visited);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parse"));
                }
                return list;
            }
        }
        List<PyRequirement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        return list;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "getName"));
        }
        return string;
    }

    @NotNull
    private static List<PyRequirement> parse(@NotNull String s, @Nullable VirtualFile anchor, @NotNull Set<VirtualFile> visited) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        LinkedHashSet<PyRequirement> result = new LinkedHashSet<PyRequirement>();
        for (String line : StringUtil.splitByLines((String)s)) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            PyRequirement req = PyRequirement.fromString(line);
            if (req != null) {
                result.add(req);
                continue;
            }
            if (anchor == null) continue;
            result.addAll(PyRequirement.parseRecursiveRequirement(trimmed, anchor, visited));
        }
        ArrayList<PyRequirement> arrayList = new ArrayList<PyRequirement>(result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parse"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PyRequirement> parseRecursiveRequirement(@NotNull String line, @NotNull VirtualFile anchor, @NotNull Set<VirtualFile> visited) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/packaging/PyRequirement", "parseRecursiveRequirement"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/packaging/PyRequirement", "parseRecursiveRequirement"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/python/packaging/PyRequirement", "parseRecursiveRequirement"));
        }
        Matcher matcher = RECURSIVE_REQUIREMENT.matcher(line);
        if (matcher.matches()) {
            String fileName = FileUtil.toSystemIndependentName((String)matcher.group(1));
            VirtualFile dir = anchor.getParent();
            if (dir != null) {
                VirtualFile file = dir.findFileByRelativePath(fileName);
                if (file == null) {
                    file = LocalFileSystem.getInstance().findFileByPath(fileName);
                }
                if (file != null) {
                    List<PyRequirement> list = PyRequirement.parse(file, visited);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parseRecursiveRequirement"));
                    }
                    return list;
                }
            }
        }
        List<PyRequirement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "parseRecursiveRequirement"));
        }
        return list;
    }

    @Nullable
    private static PyRequirement parseEditableEgg(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/packaging/PyRequirement", "parseEditableEgg"));
        }
        Matcher editableEggMatcher = EDITABLE_EGG.matcher(line);
        if (!editableEggMatcher.matches()) {
            return null;
        }
        boolean editable = editableEggMatcher.group(1) != null;
        String url = editableEggMatcher.group(2);
        String egg = editableEggMatcher.group(4);
        if (url == null) {
            return null;
        }
        if (egg == null) {
            try {
                String path;
                URI uri = new URI(url);
                if (uri.getScheme() != null && (path = uri.getPath()) != null) {
                    String[] split = path.split("@", 2);
                    Matcher vcsPathMatcher = VCS_PATH.matcher(path = split[0]);
                    if (!vcsPathMatcher.matches()) {
                        return null;
                    }
                    egg = vcsPathMatcher.group(1);
                    String gitSuffix = ".git";
                    if (egg.endsWith(".git")) {
                        egg = egg.substring(0, egg.length() - ".git".length());
                    }
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        if (egg == null) {
            return null;
        }
        boolean isName = true;
        ArrayList<String> nameParts = new ArrayList<String>();
        ArrayList<String> versionParts = new ArrayList<String>();
        for (String part : StringUtil.split((String)egg, (String)"-")) {
            if (part.matches("[0-9].*") || "dev".equals(part)) {
                isName = false;
            }
            if (isName) {
                nameParts.add(part);
                continue;
            }
            versionParts.add(part);
        }
        String name = PyRequirement.normalizeName(StringUtil.join(nameParts, (String)"-"));
        String version = !versionParts.isEmpty() ? PyRequirement.normalizeVersion(StringUtil.join(versionParts, (String)"-")) : null;
        return new PyRequirement(name, version, url, editable);
    }

    @NotNull
    private static String normalizeName(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/packaging/PyRequirement", "normalizeName"));
        }
        String string = s.replace("_", "-");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "normalizeName"));
        }
        return string;
    }

    @NotNull
    private static String normalizeVersion(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/packaging/PyRequirement", "normalizeVersion"));
        }
        String string = s.replace("_", "-").replaceAll("-?py[0-9\\.]+", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "normalizeVersion"));
        }
        return string;
    }

    public static class VersionSpec {
        @NotNull
        private final Relation myRelation;
        @NotNull
        private final String myVersion;

        public VersionSpec(@NotNull Relation relation, @NotNull String version) {
            if (relation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relation", "com/jetbrains/python/packaging/PyRequirement$VersionSpec", "<init>"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/python/packaging/PyRequirement$VersionSpec", "<init>"));
            }
            this.myRelation = relation;
            this.myVersion = version;
        }

        public String toString() {
            return (Object)((Object)this.myRelation) + this.myVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionSpec spec = (VersionSpec)o;
            if (this.myRelation != spec.myRelation) {
                return false;
            }
            return this.myVersion.equals(spec.myVersion);
        }

        public int hashCode() {
            int result = this.myRelation.hashCode();
            result = 31 * result + this.myVersion.hashCode();
            return result;
        }

        @NotNull
        public Relation getRelation() {
            Relation relation = this.myRelation;
            if (relation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement$VersionSpec", "getRelation"));
            }
            return relation;
        }

        @NotNull
        public String getVersion() {
            String string = this.myVersion;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement$VersionSpec", "getVersion"));
            }
            return string;
        }
    }

    public static enum Relation {
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">="),
        EQ("=="),
        NE("!=");

        @NotNull
        private final String myValue;

        private Relation(String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/packaging/PyRequirement$Relation", "<init>"));
            }
            this.myValue = value;
        }

        @NotNull
        public String toString() {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement$Relation", "toString"));
            }
            return string;
        }

        @Nullable
        public static Relation fromString(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/packaging/PyRequirement$Relation", "fromString"));
            }
            for (Relation relation : Relation.values()) {
                if (!relation.myValue.equals(value)) continue;
                return relation;
            }
            return null;
        }

        public boolean isSuccessful(int comparisonResult) {
            switch (this) {
                case LT: {
                    return comparisonResult < 0;
                }
                case LTE: {
                    return comparisonResult <= 0;
                }
                case GT: {
                    return comparisonResult > 0;
                }
                case GTE: {
                    return comparisonResult >= 0;
                }
                case EQ: {
                    return comparisonResult == 0;
                }
                case NE: {
                    return comparisonResult != 0;
                }
            }
            return false;
        }
    }
}

