/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePackageManagerImpl
extends PyPackageManagerImpl {
    private static final Logger LOG = Logger.getInstance(PyRemotePackageManagerImpl.class);

    PyRemotePackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl", "<init>"));
        }
        super(sdk);
    }

    @Override
    @Nullable
    protected String getHelperPath(String helper) throws ExecutionException {
        SdkAdditionalData sdkData = this.mySdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
            try {
                RemoteSdkCredentials remoteSdkCredentials = remoteSdkData.getRemoteSdkCredentials(false);
                if (!StringUtil.isEmpty((String)remoteSdkCredentials.getHelpersPath())) {
                    return new RemoteFile(remoteSdkCredentials.getHelpersPath(), helper).getPath();
                }
                return null;
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                throw this.analyzeException(e, helper, Collections.<String>emptyList());
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (helperPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helperPath", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl", "getPythonProcessOutput"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl", "getPythonProcessOutput"));
        }
        String homePath = this.mySdk.getHomePath();
        if (homePath == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + this.mySdk.getName());
        }
        SdkAdditionalData sdkData = this.mySdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            RemoteSdkCredentials remoteSdkCredentials;
            try {
                remoteSdkCredentials = ((RemoteSdkAdditionalData)sdkData).getRemoteSdkCredentials(false);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                remoteSdkCredentials = null;
            }
            catch (ExecutionException e) {
                throw this.analyzeException(e, helperPath, args);
            }
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null && remoteSdkCredentials != null) {
                ProcessOutput processOutput;
                ArrayList<String> cmdline = new ArrayList<String>();
                cmdline.add(homePath);
                cmdline.add(RemoteFile.detectSystemByPath(homePath).createRemoteFile(helperPath).getPath());
                cmdline.addAll(Collections2.transform(args, (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return PyRemotePackageManagerImpl.quoteIfNeeded(input);
                    }
                }));
                if (askForSudo) {
                    askForSudo = !manager.ensureCanWrite(null, remoteSdkCredentials, remoteSdkCredentials.getInterpreterPath());
                }
                do {
                    PathMappingSettings mappings = manager.setupMappings(null, (PyRemoteSdkAdditionalDataBase)sdkData, null);
                    processOutput = manager.runRemoteProcess(null, remoteSdkCredentials, mappings, ArrayUtil.toStringArray(cmdline), workingDir, askForSudo);
                } while (askForSudo && processOutput.getStderr().contains("sudo: 3 incorrect password attempts"));
                ProcessOutput processOutput2 = processOutput;
                if (processOutput2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl", "getPythonProcessOutput"));
                }
                return processOutput2;
            }
            throw new PyExecutionException("Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.", helperPath, args);
        }
        throw new PyExecutionException("Invalid remote SDK", helperPath, args);
    }

    private ExecutionException analyzeException(ExecutionException exception, String command, List<String> args) {
        Throwable cause = exception.getCause();
        if (cause instanceof VagrantNotStartedException) {
            String vagrantFolder = ((VagrantNotStartedException)cause).getVagrantFolder();
            return new PyExecutionException("Vagrant instance is down", command, args, "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new LaunchVagrantFix(vagrantFolder)));
        }
        return exception;
    }

    @Override
    protected void subscribeToLocalChanges(Sdk sdk) {
    }

    @Override
    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl", "installManagement"));
        }
        super.installManagement(name);
    }

    private static String quoteIfNeeded(String arg) {
        return arg.replace("<", "\\<").replace(">", "\\>");
    }

    private class LaunchVagrantFix
    implements PyExecutionFix {
        @NotNull
        private final String myVagrantFolder;

        public LaunchVagrantFix(String vagrantFolder) {
            if (vagrantFolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix", "<init>"));
            }
            this.myVagrantFolder = vagrantFolder;
        }

        @Override
        @NotNull
        public String getName() {
            if ("Launch Vagrant" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix", "getName"));
            }
            return "Launch Vagrant";
        }

        @Override
        public void run(@NotNull Sdk sdk) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix", "run"));
            }
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                try {
                    manager.runVagrant(this.myVagrantFolder);
                    PyRemotePackageManagerImpl.this.clearCaches();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

