/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageUtil {
    public static final String[] SETUP_PY_REQUIRES_KWARGS_NAMES = new String[]{"requires", "install_requires", "setup_requires", "tests_require"};

    private PyPackageUtil() {
    }

    @Nullable
    public static PyFile findSetupPy(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageUtil", "findSetupPy"));
        }
        for (VirtualFile root : PyUtil.getSourceRoots(module)) {
            PsiFile file;
            VirtualFile child = root.findChild("setup.py");
            if (child == null || !((file = PsiManager.getInstance((Project)module.getProject()).findFile(child)) instanceof PyFile)) continue;
            return (PyFile)file;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findRequirementsTxt(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageUtil", "findRequirementsTxt"));
        }
        String requirementsPath = PyPackageRequirementsSettings.getInstance(module).getRequirementsPath();
        if (!requirementsPath.isEmpty()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(requirementsPath);
            if (file != null) {
                return file;
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile root : manager.getContentRoots()) {
                VirtualFile fileInRoot = root.findFileByRelativePath(requirementsPath);
                if (fileInRoot == null) continue;
                return fileInRoot;
            }
        }
        return null;
    }

    @Nullable
    public static PyListLiteralExpression findSetupPyRequires(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageUtil", "findSetupPyRequires"));
        }
        for (String name : SETUP_PY_REQUIRES_KWARGS_NAMES) {
            PyListLiteralExpression kwarg = PyPackageUtil.findSetupPyRequires(module, name);
            if (kwarg == null) continue;
            return kwarg;
        }
        return null;
    }

    @Nullable
    public static PyListLiteralExpression findSetupPyRequires(@NotNull Module module, @NotNull String kwargName) {
        PyCallExpression setup;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageUtil", "findSetupPyRequires"));
        }
        if (kwargName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kwargName", "com/jetbrains/python/packaging/PyPackageUtil", "findSetupPyRequires"));
        }
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        if (setupPy != null && (setup = PyPackageUtil.findSetupCall(setupPy)) != null) {
            for (PyExpression arg : setup.getArguments()) {
                PyResolveContext resolveContext;
                QualifiedResolveResult result;
                PsiElement element;
                PyKeywordArgument kwarg;
                if (!(arg instanceof PyKeywordArgument) || !kwargName.equals((kwarg = (PyKeywordArgument)arg).getKeyword())) continue;
                PyExpression value = kwarg.getValueExpression();
                if (value instanceof PyListLiteralExpression) {
                    return (PyListLiteralExpression)value;
                }
                if (!(value instanceof PyReferenceExpression) || !((element = (result = ((PyReferenceExpression)value).followAssignmentsChain(resolveContext = PyResolveContext.defaultContext())).getElement()) instanceof PyListLiteralExpression)) continue;
                return (PyListLiteralExpression)element;
            }
        }
        return null;
    }

    @NotNull
    public static List<String> getPackageNames(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageUtil", "getPackageNames"));
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Project project = module.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (roots.length == 0) {
            roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        }
        for (VirtualFile root : roots) {
            PyPackageUtil.collectPackageNames(project, root, packageNames);
        }
        ArrayList<String> arrayList = packageNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageUtil", "getPackageNames"));
        }
        return arrayList;
    }

    @NotNull
    public static String requirementsToString(@NotNull List<PyRequirement> requirements) {
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/PyPackageUtil", "requirementsToString"));
        }
        String string = StringUtil.join(requirements, (Function)new Function<PyRequirement, String>(){

            public String fun(PyRequirement requirement) {
                return String.format("'%s'", requirement.toString());
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageUtil", "requirementsToString"));
        }
        return string;
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull PyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil", "findSetupCall"));
        }
        final Ref result = new Ref(null);
        file.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                PyExpression callee = node.getCallee();
                String name = PyUtil.getReadableRepr((PsiElement)callee, true);
                if ("setup".equals(name)) {
                    result.set((Object)node);
                }
            }

            @Override
            public void visitPyElement(PyElement node) {
                if (!(node instanceof ScopeOwner)) {
                    super.visitPyElement(node);
                }
            }
        });
        return (PyCallExpression)result.get();
    }

    private static void collectPackageNames(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull List<String> results) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/PyPackageUtil", "collectPackageNames"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/python/packaging/PyPackageUtil", "collectPackageNames"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/jetbrains/python/packaging/PyPackageUtil", "collectPackageNames"));
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil$3", "visitFile"));
                }
                if (!fileIndex.isExcluded(file) && file.isDirectory() && file.findChild("__init__.py") != null) {
                    results.add(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'.'));
                }
                return true;
            }
        });
    }
}

