/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@State(name="PyPackageService", storages={@Storage(file="$APP_CONFIG$/packages.xml")})
public class PyPackageService
implements PersistentStateComponent<PyPackageService> {
    public Map<String, Boolean> sdkToUsersite = new HashMap<String, Boolean>();
    public List<String> additionalRepositories = new ArrayList<String>();
    public Map<String, String> PY_PACKAGES = new ConcurrentHashMap();
    public String virtualEnvBasePath;
    public long LAST_TIME_CHECKED = 0L;

    public PyPackageService getState() {
        return this;
    }

    public void loadState(PyPackageService state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public void addSdkToUserSite(String sdk, boolean useUsersite) {
        this.sdkToUsersite.put(sdk, useUsersite);
    }

    public void addRepository(String repository) {
        this.additionalRepositories.add(repository);
    }

    public void removeRepository(String repository) {
        if (this.additionalRepositories.contains(repository)) {
            this.additionalRepositories.remove(repository);
        }
    }

    public boolean useUserSite(String sdk) {
        if (this.sdkToUsersite.containsKey(sdk)) {
            return this.sdkToUsersite.get(sdk);
        }
        return false;
    }

    public static PyPackageService getInstance() {
        return (PyPackageService)ServiceManager.getService(PyPackageService.class);
    }

    public String getVirtualEnvBasePath() {
        return this.virtualEnvBasePath;
    }

    public void setVirtualEnvBasePath(String virtualEnvBasePath) {
        this.virtualEnvBasePath = virtualEnvBasePath;
    }
}

