/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyRemotePackageManagerImpl;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyPackageManagersImpl
extends PyPackageManagers {
    private final Map<String, PyPackageManagerImpl> myInstances = new HashMap<String, PyPackageManagerImpl>();

    @Override
    @NotNull
    public synchronized PyPackageManager forSdk(Sdk sdk) {
        String name = sdk.getName();
        PyPackageManagerImpl manager = this.myInstances.get(name);
        if (manager == null) {
            manager = PythonSdkType.isRemote(sdk) ? new PyRemotePackageManagerImpl(sdk) : new PyPackageManagerImpl(sdk);
            this.myInstances.put(name, manager);
        }
        PyPackageManagerImpl pyPackageManagerImpl = manager;
        if (pyPackageManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagersImpl", "forSdk"));
        }
        return pyPackageManagerImpl;
    }
}

