/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerUI {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PyPackageManagerUI.class);
    @Nullable
    private Listener myListener;
    @NotNull
    private Project myProject;
    @NotNull
    private Sdk mySdk;

    public PyPackageManagerUI(@NotNull Project project, @NotNull Sdk sdk, @Nullable Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/PyPackageManagerUI", "<init>"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerUI", "<init>"));
        }
        this.myProject = project;
        this.mySdk = sdk;
        this.myListener = listener;
    }

    public void installManagement() {
        ProgressManager.getInstance().run((Task)new InstallManagementTask(this.myProject, this.mySdk, this.myListener));
    }

    public void install(@NotNull List<PyRequirement> requirements, @NotNull List<String> extraArgs) {
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/PyPackageManagerUI", "install"));
        }
        if (extraArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraArgs", "com/jetbrains/python/packaging/PyPackageManagerUI", "install"));
        }
        ProgressManager.getInstance().run((Task)new InstallTask(this.myProject, this.mySdk, requirements, extraArgs, this.myListener));
    }

    public void uninstall(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyPackageManagerUI", "uninstall"));
        }
        if (this.checkDependents(packages)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new UninstallTask(this.myProject, this.mySdk, this.myListener, packages));
    }

    private boolean checkDependents(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyPackageManagerUI", "checkDependents"));
        }
        try {
            final Map<String, Set<PyPackage>> dependentPackages = PyPackageManagerUI.collectDependents(packages, this.mySdk);
            final int[] warning = new int[]{0};
            if (!dependentPackages.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (dependentPackages.size() == 1) {
                            String message = "You are attempting to uninstall ";
                            ArrayList<String> dep = new ArrayList<String>();
                            int size = 1;
                            for (Map.Entry entry : dependentPackages.entrySet()) {
                                Set value = (Set)entry.getValue();
                                size = value.size();
                                dep.add((String)entry.getKey() + " package which is required for " + StringUtil.join((Iterable)value, (String)", "));
                            }
                            message = message + StringUtil.join(dep, (String)"\n");
                            message = message + (size == 1 ? " package" : " packages");
                            message = message + "\n\nDo you want to proceed?";
                            warning[0] = Messages.showYesNoDialog((String)message, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                        } else {
                            String message = "You are attempting to uninstall packages which are required for another packages.\n\n";
                            ArrayList<String> dep = new ArrayList<String>();
                            for (Map.Entry entry : dependentPackages.entrySet()) {
                                dep.add((String)entry.getKey() + " -> " + StringUtil.join((Iterable)((Iterable)entry.getValue()), (String)", "));
                            }
                            message = message + StringUtil.join(dep, (String)"\n");
                            message = message + "\n\nDo you want to proceed?";
                            warning[0] = Messages.showYesNoDialog((String)message, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                        }
                    }
                }, ModalityState.current());
            }
            if (warning[0] != 0) {
                return true;
            }
        }
        catch (ExecutionException e) {
            LOG.info("Error loading packages dependents: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static Map<String, Set<PyPackage>> collectDependents(@NotNull List<PyPackage> packages, Sdk sdk) throws ExecutionException {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyPackageManagerUI", "collectDependents"));
        }
        HashMap<String, Set<PyPackage>> dependentPackages = new HashMap<String, Set<PyPackage>>();
        for (PyPackage pkg : packages) {
            Set<PyPackage> dependents = PyPackageManager.getInstance(sdk).getDependents(pkg);
            if (dependents == null || dependents.isEmpty()) continue;
            for (PyPackage dependent : dependents) {
                if (packages.contains(dependent)) continue;
                dependentPackages.put(pkg.getName(), dependents);
            }
        }
        return dependentPackages;
    }

    private static class UninstallTask
    extends PackagingTask {
        @NotNull
        private final List<PyPackage> myPackages;

        public UninstallTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener, @NotNull List<PyPackage> packages) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "<init>"));
            }
            if (packages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "<init>"));
            }
            super(project, sdk, "Uninstalling packages", listener);
            this.myPackages = packages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            List<ExecutionException> list;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "runTask"));
            }
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setIndeterminate(true);
            try {
                manager.uninstall(this.myPackages);
                List<ExecutionException> list2 = Collections.emptyList();
                list = list2;
            }
            catch (ExecutionException e) {
                List<ExecutionException> list3 = Collections.singletonList(e);
                List<ExecutionException> list4 = list3;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "runTask"));
                }
                return list4;
            }
            finally {
                manager.refresh();
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "runTask"));
            }
            return list;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            if ("Packages uninstalled successfully" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "getSuccessTitle"));
            }
            return "Packages uninstalled successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String packagesString = StringUtil.join(this.myPackages, (Function)new Function<PyPackage, String>(){

                public String fun(PyPackage pkg) {
                    return "'" + pkg.getName() + "'";
                }
            }, (String)", ");
            String string = "Uninstalled packages: " + packagesString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "getSuccessDescription"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            if ("Uninstall packages failed" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask", "getFailureTitle"));
            }
            return "Uninstall packages failed";
        }
    }

    private static class InstallManagementTask
    extends InstallTask {
        public InstallManagementTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask", "<init>"));
            }
            super(project, sdk, Collections.<PyRequirement>emptyList(), Collections.<String>emptyList(), listener);
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask", "runTask"));
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setText("Installing packaging tools...");
            indicator.setIndeterminate(true);
            try {
                manager.installManagement();
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
            manager.refresh();
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask", "runTask"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            if ("Installed Python packaging tools" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask", "getSuccessDescription"));
            }
            return "Installed Python packaging tools";
        }
    }

    private static class InstallTask
    extends PackagingTask {
        @NotNull
        private final List<PyRequirement> myRequirements;
        @NotNull
        private final List<String> myExtraArgs;

        public InstallTask(@Nullable Project project, @NotNull Sdk sdk, @NotNull List<PyRequirement> requirements, @NotNull List<String> extraArgs, @Nullable Listener listener) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "<init>"));
            }
            if (requirements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "<init>"));
            }
            if (extraArgs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraArgs", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "<init>"));
            }
            super(project, sdk, "Installing packages", listener);
            this.myRequirements = requirements;
            this.myExtraArgs = extraArgs;
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "runTask"));
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            int size = this.myRequirements.size();
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            for (int i = 0; i < size; ++i) {
                PyRequirement requirement = this.myRequirements.get(i);
                indicator.setText(String.format("Installing package '%s'...", requirement));
                if (i == 0) {
                    indicator.setIndeterminate(true);
                } else {
                    indicator.setIndeterminate(false);
                    indicator.setFraction((double)i / (double)size);
                }
                try {
                    manager.install(Collections.singletonList(requirement), this.myExtraArgs);
                    continue;
                }
                catch (RunCanceledByUserException e) {
                    exceptions.add((ExecutionException)((Object)e));
                    break;
                }
                catch (ExecutionException e) {
                    exceptions.add(e);
                }
            }
            manager.refresh();
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "runTask"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            if ("Packages installed successfully" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "getSuccessTitle"));
            }
            return "Packages installed successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String string = "Installed packages: " + PyPackageUtil.requirementsToString(this.myRequirements);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "getSuccessDescription"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            if ("Install packages failed" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask", "getFailureTitle"));
            }
            return "Install packages failed";
        }
    }

    private static abstract class PackagingTask
    extends Task.Backgroundable {
        private static final String PACKAGING_GROUP_ID = "Packaging";
        @NotNull
        protected final Sdk mySdk;
        @Nullable
        protected final Listener myListener;

        public PackagingTask(@Nullable Project project, @NotNull Sdk sdk, @NotNull String title, @Nullable Listener listener) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask", "<init>"));
            }
            super(project, title);
            this.mySdk = sdk;
            this.myListener = listener;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask", "run"));
            }
            this.taskStarted(indicator);
            this.taskFinished(this.runTask(indicator));
        }

        @NotNull
        protected abstract List<ExecutionException> runTask(@NotNull ProgressIndicator var1);

        @NotNull
        protected abstract String getSuccessTitle();

        @NotNull
        protected abstract String getSuccessDescription();

        @NotNull
        protected abstract String getFailureTitle();

        protected void taskStarted(@NotNull ProgressIndicator indicator) {
            PackagingNotification[] notifications;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask", "taskStarted"));
            }
            for (PackagingNotification notification : notifications = (PackagingNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(PackagingNotification.class, this.getProject())) {
                notification.expire();
            }
            indicator.setText(this.getTitle() + "...");
            if (this.myListener != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PackagingTask.this.myListener.started();
                    }
                });
            }
        }

        protected void taskFinished(final @NotNull List<ExecutionException> exceptions) {
            if (exceptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask", "taskFinished"));
            }
            final Ref notificationRef = new Ref(null);
            if (exceptions.isEmpty()) {
                notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getSuccessTitle(), this.getSuccessDescription(), NotificationType.INFORMATION, null));
            } else {
                final PackageManagementService.ErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, this.mySdk);
                if (description != null) {
                    String firstLine = this.getTitle() + ": error occurred.";
                    NotificationListener listener = new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$2", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$2", "hyperlinkUpdate"));
                            }
                            assert (PackagingTask.this.myProject != null);
                            String title = StringUtil.capitalizeWords((String)PackagingTask.this.getFailureTitle(), (boolean)true);
                            PackagesNotificationPanel.showError(title, description);
                        }
                    };
                    notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getFailureTitle(), firstLine + " <a href=\"xxx\">Details...</a>", NotificationType.ERROR, listener));
                }
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Notification notification;
                    if (PackagingTask.this.myListener != null) {
                        PackagingTask.this.myListener.finished(exceptions);
                    }
                    if ((notification = (Notification)notificationRef.get()) != null) {
                        notification.notify(PackagingTask.this.myProject);
                    }
                }
            });
        }

        private static class PackagingNotification
        extends Notification {
            public PackagingNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
                if (groupDisplayId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification", "<init>"));
                }
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification", "<init>"));
                }
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification", "<init>"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification", "<init>"));
                }
                super(groupDisplayId, title, content, type, listener);
            }
        }
    }

    public static interface Listener {
        public void started();

        public void finished(List<ExecutionException> var1);
    }
}

