/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.HttpConfigurable;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManager {
    public static final String SETUPTOOLS_PRE_26_VERSION = "1.4.2";
    public static final String PIP_PRE_26_VERSION = "1.1";
    public static final String VIRTUALENV_PRE_26_VERSION = "1.7.2";
    public static final String SETUPTOOLS_VERSION = "5.7";
    public static final String PIP_VERSION = "1.5.6";
    public static final String VIRTUALENV_VERSION = "1.11.6";
    public static final int OK = 0;
    public static final int ERROR_NO_SETUPTOOLS = 3;
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImpl.class);
    private static final String PACKAGING_TOOL = "packaging_tool.py";
    private static final int TIMEOUT = 600000;
    private static final String BUILD_DIR_OPTION = "--build-dir";
    public static final String INSTALL = "install";
    public static final String UNINSTALL = "uninstall";
    public static final String UNTAR = "untar";
    private final Object myCacheLock;
    private List<PyPackage> myPackagesCache;
    private ExecutionException myExceptionCache;
    protected Sdk mySdk;

    @Override
    public void refresh() {
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                application.runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile[] files;
                        for (VirtualFile file : files = PyPackageManagerImpl.this.mySdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                            file.refresh(true, true);
                        }
                    }
                });
                PythonSdkType.getInstance().setupSdkPaths(PyPackageManagerImpl.this.mySdk);
                PyPackageManagerImpl.this.clearCaches();
            }
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        String name;
        boolean pre26 = PythonSdkType.getLanguageLevelForSdk(this.mySdk).isOlderThan(LanguageLevel.PYTHON26);
        if (!this.hasSetuptools(false)) {
            name = "setuptools-" + (pre26 ? SETUPTOOLS_PRE_26_VERSION : SETUPTOOLS_VERSION);
            this.installManagement(name);
        }
        if (!this.hasPackage("pip", false)) {
            name = "pip-" + (pre26 ? PIP_PRE_26_VERSION : PIP_VERSION);
            this.installManagement(name);
        }
    }

    @Override
    public boolean hasManagement(boolean cachedOnly) throws ExecutionException {
        return this.hasSetuptools(cachedOnly) && this.hasPackage("pip", cachedOnly);
    }

    private boolean hasSetuptools(boolean cachedOnly) throws ExecutionException {
        try {
            return this.hasPackage("setuptools", cachedOnly) || this.hasPackage("distribute", cachedOnly);
        }
        catch (PyExecutionException e) {
            if (e.getExitCode() == 3) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyPackageManagerImpl", "installManagement"));
        }
        String dirName = this.extractHelper(name + ".tar.gz");
        try {
            String fileName = dirName + name + File.separatorChar + "setup.py";
            this.getPythonProcessResult(fileName, Collections.singletonList(INSTALL), true, true, dirName + name);
        }
        finally {
            this.clearCaches();
            FileUtil.delete((File)new File(dirName));
        }
    }

    @NotNull
    private String extractHelper(@NotNull String name) throws ExecutionException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyPackageManagerImpl", "extractHelper"));
        }
        String helperPath = this.getHelperPath(name);
        ArrayList args = Lists.newArrayList((Object[])new String[]{UNTAR, helperPath});
        String result = this.getHelperResult(PACKAGING_TOOL, args, false, false, null);
        String dirName = FileUtil.toSystemDependentName((String)result.trim());
        if (!dirName.endsWith(File.separator)) {
            dirName = dirName + File.separator;
        }
        String string = dirName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "extractHelper"));
        }
        return string;
    }

    private boolean hasPackage(@NotNull String name, boolean cachedOnly) throws ExecutionException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyPackageManagerImpl", "hasPackage"));
        }
        return this.findPackage(name, cachedOnly) != null;
    }

    PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/PyPackageManagerImpl", "<init>"));
        }
        this.myCacheLock = new Object();
        this.myPackagesCache = null;
        this.myExceptionCache = null;
        this.mySdk = sdk;
        this.subscribeToLocalChanges(sdk);
    }

    protected void subscribeToLocalChanges(Sdk sdk) {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MySdkRootWatcher());
    }

    public Sdk getSdk() {
        return this.mySdk;
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirementString", "com/jetbrains/python/packaging/PyPackageManagerImpl", INSTALL));
        }
        this.installManagement();
        this.install(Collections.singletonList(PyRequirement.fromString(requirementString)), Collections.<String>emptyList());
    }

    @Override
    public void install(@NotNull List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        File buildDir;
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/PyPackageManagerImpl", INSTALL));
        }
        if (extraArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraArgs", "com/jetbrains/python/packaging/PyPackageManagerImpl", INSTALL));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(INSTALL);
        try {
            buildDir = FileUtil.createTempDirectory((String)"pycharm-packaging", null);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create temporary build directory");
        }
        if (!extraArgs.contains(BUILD_DIR_OPTION)) {
            args.addAll(Arrays.asList(BUILD_DIR_OPTION, buildDir.getAbsolutePath()));
        }
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyPackageManagerImpl.getProxyString();
        if (proxyString != null) {
            args.add("--proxy");
            args.add(proxyString);
        }
        args.addAll(extraArgs);
        for (PyRequirement req : requirements) {
            args.addAll(req.toOptions());
        }
        try {
            this.getHelperResult(PACKAGING_TOOL, args, !useUserSite, true, null);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add(INSTALL);
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements) {
                simplifiedArgs.addAll(req.toOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", simplifiedArgs, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            this.clearCaches();
            FileUtil.delete((File)buildDir);
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/jetbrains/python/packaging/PyPackageManagerImpl", UNINSTALL));
        }
        ArrayList<String> args = new ArrayList<String>();
        try {
            args.add(UNINSTALL);
            boolean canModify = true;
            for (PyPackage pkg : packages) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = FileUtil.ensureCanCreateFile((File)new File(location));
                }
                args.add(pkg.getName());
            }
            this.getHelperResult(PACKAGING_TOOL, args, !canModify, true, null);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            this.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<PyPackage> getPackages(boolean cachedOnly) throws ExecutionException {
        Object object = this.myCacheLock;
        synchronized (object) {
            if (this.myPackagesCache != null) {
                return new ArrayList<PyPackage>(this.myPackagesCache);
            }
            if (this.myExceptionCache != null) {
                throw this.myExceptionCache;
            }
            if (cachedOnly) {
                return null;
            }
        }
        try {
            String output = this.getHelperResult(PACKAGING_TOOL, Arrays.asList("list"), false, false, null);
            List<PyPackage> packages = PyPackageManagerImpl.parsePackagingToolOutput(output);
            Object object2 = this.myCacheLock;
            synchronized (object2) {
                this.myPackagesCache = packages;
                return new ArrayList<PyPackage>(this.myPackagesCache);
            }
        }
        catch (ExecutionException e) {
            Object object3 = this.myCacheLock;
            synchronized (object3) {
                this.myExceptionCache = e;
            }
            throw e;
        }
    }

    @Override
    @Nullable
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getDependents"));
        }
        List<PyPackage> packages = this.getPackages(false);
        if (packages != null) {
            HashSet<PyPackage> dependents = new HashSet<PyPackage>();
            for (PyPackage p : packages) {
                List<PyRequirement> requirements = p.getRequirements();
                for (PyRequirement requirement : requirements) {
                    if (!requirement.getName().equals(pkg.getName())) continue;
                    dependents.add(p);
                }
            }
            return dependents;
        }
        return null;
    }

    @Override
    @Nullable
    public PyPackage findPackage(@NotNull String name, boolean cachedOnly) throws ExecutionException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyPackageManagerImpl", "findPackage"));
        }
        List<PyPackage> packages = this.getPackages(cachedOnly);
        if (packages != null) {
            for (PyPackage pkg : packages) {
                if (!name.equalsIgnoreCase(pkg.getName())) continue;
                return pkg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        VirtualFile binaryFile;
        String path;
        if (destinationDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationDir", "com/jetbrains/python/packaging/PyPackageManagerImpl", "createVirtualEnv"));
        }
        ArrayList<String> args = new ArrayList<String>();
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.mySdk);
        boolean usePyVenv = languageLevel.isAtLeast(LanguageLevel.PYTHON33);
        if (usePyVenv) {
            args.add("pyvenv");
            if (useGlobalSite) {
                args.add("--system-site-packages");
            }
            args.add(destinationDir);
            this.getHelperResult(PACKAGING_TOOL, args, false, true, null);
        } else {
            if (useGlobalSite) {
                args.add("--system-site-packages");
            }
            args.add(destinationDir);
            boolean pre26 = languageLevel.isOlderThan(LanguageLevel.PYTHON26);
            String name = "virtualenv-" + (pre26 ? VIRTUALENV_PRE_26_VERSION : VIRTUALENV_VERSION);
            String dirName = this.extractHelper(name + ".tar.gz");
            try {
                String fileName = dirName + name + File.separatorChar + "virtualenv.py";
                this.getPythonProcessResult(fileName, args, false, true, dirName + name);
            }
            finally {
                FileUtil.delete((File)new File(dirName));
            }
        }
        String binary = PythonSdkType.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + "python";
        String string = path = binary != null ? binary : binaryFallback;
        if (usePyVenv && (binaryFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null) {
            ProjectJdkImpl tmpSdk = new ProjectJdkImpl("", (SdkTypeId)PythonSdkType.getInstance());
            tmpSdk.setHomePath(path);
            PyPackageManager manager = PyPackageManager.getInstance(tmpSdk);
            manager.installManagement();
        }
        String string2 = path;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "createVirtualEnv"));
        }
        return string2;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getRequirements"));
        }
        List<PyRequirement> requirements = PySdkUtil.getRequirementsFromTxt(module);
        if (requirements != null) {
            return requirements;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String name : PyPackageUtil.SETUP_PY_REQUIRES_KWARGS_NAMES) {
            PyListLiteralExpression installRequires = PyPackageUtil.findSetupPyRequires(module, name);
            if (installRequires == null) continue;
            for (PyExpression e : installRequires.getElements()) {
                if (!(e instanceof PyStringLiteralExpression)) continue;
                lines.add(((PyStringLiteralExpression)e).getStringValue());
            }
        }
        if (!lines.isEmpty()) {
            return PyRequirement.parse(StringUtil.join(lines, (String)"\n"));
        }
        if (PyPackageUtil.findSetupPy(module) != null) {
            return Collections.emptyList();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCaches() {
        Object object = this.myCacheLock;
        synchronized (object) {
            this.myPackagesCache = null;
            this.myExceptionCache = null;
        }
    }

    @Nullable
    private static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.PROXY_LOGIN, settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    private String getHelperResult(@NotNull String helper, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String parentDir) throws ExecutionException {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getHelperResult"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getHelperResult"));
        }
        String helperPath = this.getHelperPath(helper);
        if (helperPath == null) {
            throw new ExecutionException("Cannot find external tool: " + helper);
        }
        String string = this.getPythonProcessResult(helperPath, args, askForSudo, showProgress, parentDir);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getHelperResult"));
        }
        return string;
    }

    @Nullable
    protected String getHelperPath(String helper) throws ExecutionException {
        return PythonHelpersLocator.getHelperPath(helper);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessResult"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessResult"));
        }
        ProcessOutput output = this.getPythonProcessOutput(path, args, askForSudo, showProgress, workingDir);
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new PyExecutionException("Timed out", path, args, output);
        }
        if (exitCode != 0) {
            throw new PyExecutionException("Non-zero exit code", path, args, output);
        }
        String string = output.getStdout();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessResult"));
        }
        return string;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        ProcessOutput processOutput;
        if (helperPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helperPath", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessOutput"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessOutput"));
        }
        String homePath = this.mySdk.getHomePath();
        if (homePath == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + this.mySdk.getName());
        }
        if (workingDir == null) {
            workingDir = new File(homePath).getParent();
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(homePath);
        cmdline.add(helperPath);
        cmdline.addAll(args);
        LOG.info("Running packaging tool: " + StringUtil.join(cmdline, (String)" "));
        boolean canCreate = FileUtil.ensureCanCreateFile((File)new File(homePath));
        boolean useSudo = !canCreate && !SystemInfo.isWindows && askForSudo;
        try {
            ProcessOutput result;
            Map<String, String> environment = PySdkUtil.mergeEnvVariables(System.getenv(), (Map<String, String>)ImmutableMap.of((Object)"PYTHONUNBUFFERED", (Object)"1"));
            GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withWorkDirectory(workingDir).withEnvironment(environment);
            Process process = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)"Please enter your password to make changes in system packages: ") : commandLine.createProcess();
            CapturingProcessHandler handler = new CapturingProcessHandler(process);
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && indicator != null) {
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                            for (String line : StringUtil.splitByLines((String)event.getText())) {
                                String trimmed = line.trim();
                                if (!this.isMeaningfulOutput(trimmed)) continue;
                                indicator.setText2(trimmed);
                            }
                        }
                    }

                    private boolean isMeaningfulOutput(@NotNull String trimmed) {
                        if (trimmed == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trimmed", "com/jetbrains/python/packaging/PyPackageManagerImpl$2", "isMeaningfulOutput"));
                        }
                        return trimmed.length() > 3;
                    }
                });
                result = handler.runProcessWithProgressIndicator(indicator);
            } else {
                result = handler.runProcess(600000);
            }
            if (result.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                String message = StringUtil.isEmptyOrSpaces((String)result.getStdout()) && StringUtil.isEmptyOrSpaces((String)result.getStderr()) ? "Permission denied" : "Non-zero exit code";
                throw new PyExecutionException(message, helperPath, args, result);
            }
            processOutput = result;
        }
        catch (IOException e) {
            throw new PyExecutionException(e.getMessage(), helperPath, args);
        }
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "getPythonProcessOutput"));
        }
        return processOutput;
    }

    @NotNull
    private static List<PyPackage> parsePackagingToolOutput(@NotNull String s) throws ExecutionException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/packaging/PyPackageManagerImpl", "parsePackagingToolOutput"));
        }
        String[] lines = StringUtil.splitByLines((String)s);
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line : lines) {
            List fields = StringUtil.split((String)line, (String)"\t");
            if (fields.size() < 3) {
                throw new PyExecutionException("Invalid output format", PACKAGING_TOOL, Collections.<String>emptyList());
            }
            String name = (String)fields.get(0);
            String version = (String)fields.get(1);
            String location = (String)fields.get(2);
            ArrayList<PyRequirement> requirements = new ArrayList<PyRequirement>();
            if (fields.size() >= 4) {
                String requiresLine = (String)fields.get(3);
                String requiresSpec = StringUtil.join((Collection)StringUtil.split((String)requiresLine, (String)":"), (String)"\n");
                requirements.addAll(PyRequirement.parse(requiresSpec));
            }
            if ("Python".equals(name)) continue;
            packages.add(new PyPackage(name, version, location, requirements));
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackageManagerImpl", "parsePackagingToolOutput"));
        }
        return arrayList;
    }

    private class MySdkRootWatcher
    extends BulkFileListener.Adapter {
        private MySdkRootWatcher() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/packaging/PyPackageManagerImpl$MySdkRootWatcher", "after"));
            }
            VirtualFile[] roots = PyPackageManagerImpl.this.mySdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            for (VFileEvent vFileEvent : events) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    PyPackageManagerImpl.this.clearCaches();
                    return;
                }
            }
        }
    }
}

