/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyPackageManager {
    public static final Key<Boolean> RUNNING_PACKAGING_TASKS = Key.create((String)"PyPackageRequirementsInspection.RunningPackagingTasks");
    public static final String SETUPTOOLS = "setuptools";
    public static final String PIP = "pip";
    public static final String DISTRIBUTE = "distribute";
    public static final String USE_USER_SITE = "--user";

    public static PyPackageManager getInstance(Sdk sdk) {
        return PyPackageManagers.getInstance().forSdk(sdk);
    }

    public abstract void installManagement() throws ExecutionException;

    public abstract boolean hasManagement(boolean var1) throws ExecutionException;

    public abstract void install(@NotNull String var1) throws ExecutionException;

    public abstract void install(@NotNull List<PyRequirement> var1, @NotNull List<String> var2) throws ExecutionException;

    public abstract void uninstall(@NotNull List<PyPackage> var1) throws ExecutionException;

    public abstract void refresh();

    @NotNull
    public abstract String createVirtualEnv(@NotNull String var1, boolean var2) throws ExecutionException;

    @Nullable
    public abstract List<PyPackage> getPackages(boolean var1) throws ExecutionException;

    @Nullable
    public abstract PyPackage findPackage(@NotNull String var1, boolean var2) throws ExecutionException;

    @Nullable
    public abstract List<PyRequirement> getRequirements(@NotNull Module var1);

    @Nullable
    public abstract Set<PyPackage> getDependents(@NotNull PyPackage var1) throws ExecutionException;
}

