/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackage
extends InstalledPackage {
    private final String myLocation;
    private final List<PyRequirement> myRequirements;

    public PyPackage(@NotNull String name, @NotNull String version, @Nullable String location, @NotNull List<PyRequirement> requirements) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/packaging/PyPackage", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/python/packaging/PyPackage", "<init>"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/PyPackage", "<init>"));
        }
        super(name, version);
        this.myLocation = location;
        this.myRequirements = requirements;
    }

    @NotNull
    public List<PyRequirement> getRequirements() {
        List<PyRequirement> list = this.myRequirements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyPackage", "getRequirements"));
        }
        return list;
    }

    public boolean matches(@NotNull PyRequirement requirement) {
        if (requirement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirement", "com/jetbrains/python/packaging/PyPackage", "matches"));
        }
        return requirement.match(Lists.newArrayList((Object[])new PyPackage[]{this})) != null;
    }

    @Nullable
    public String getLocation() {
        return this.myLocation;
    }

    public boolean isInstalled() {
        return this.myLocation != null;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return FileUtil.getLocationRelativeToUserHome((String)this.myLocation);
    }
}

