/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PyPIPackagesUpdater
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.packaging.PyPIPackagesUpdater");

    public static PyPIPackagesUpdater getInstance() {
        StartupActivity[] extensions;
        for (StartupActivity extension : extensions = (StartupActivity[])Extensions.getExtensions((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY)) {
            if (!(extension instanceof PyPIPackagesUpdater)) continue;
            return (PyPIPackagesUpdater)extension;
        }
        throw new UnsupportedOperationException("could not find self");
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/PyPIPackagesUpdater", "runActivity"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final PyPackageService service = PyPackageService.getInstance();
        if (PyPIPackagesUpdater.checkNeeded(project, service)) {
            application.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PyPIPackageUtil.INSTANCE.updatePyPICache(service);
                        service.LAST_TIME_CHECKED = System.currentTimeMillis();
                    }
                    catch (IOException e) {
                        LOG.warn(e.getMessage());
                    }
                }
            });
        }
    }

    public static boolean checkNeeded(Project project, PyPackageService service) {
        boolean hasPython = false;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkType.findPythonSdk(module);
            if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
            hasPython = true;
            break;
        }
        if (!hasPython) {
            return false;
        }
        long timeDelta = System.currentTimeMillis() - service.LAST_TIME_CHECKED;
        return Math.abs(timeDelta) >= 86400000L;
    }
}

