/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyPackageService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.DefaultXmlRpcTransport;
import org.apache.xmlrpc.DefaultXmlRpcTransportFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPIPackageUtil {
    public static final Logger LOG = Logger.getInstance((String)PyPIPackageUtil.class.getName());
    @NonNls
    public static final String PYPI_URL = "https://pypi.python.org/pypi";
    @NonNls
    public static final String PYPI_LIST_URL = "https://pypi.python.org/pypi?%3Aaction=index";
    public static final PyPIPackageUtil INSTANCE = new PyPIPackageUtil();
    private XmlRpcClient myXmlRpcClient;
    private Map<String, Hashtable> packageToDetails = new HashMap<String, Hashtable>();
    private Map<String, List<String>> packageToReleases = new HashMap<String, List<String>>();
    private Pattern PYPI_PATTERN = Pattern.compile("/pypi/([^/]*)/(.*)");
    private Set<RepoPackage> myAdditionalPackageNames;
    @Nullable
    private volatile Set<String> myPackageNames = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getPackageNames(String url) throws IOException {
        final TreeSet<String> names = new TreeSet<String>();
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            HTML.Tag myTag;

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
                this.myTag = tag;
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.myTag != null && "a".equals(this.myTag.toString())) {
                    names.add(String.valueOf(data));
                }
            }
        };
        try {
            URL repositoryUrl = new URL(url);
            InputStream is = repositoryUrl.openStream();
            InputStreamReader reader = new InputStreamReader(is);
            try {
                new ParserDelegator().parse(reader, callback, true);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Throwable)e);
        }
        return names;
    }

    public Set<RepoPackage> getAdditionalPackageNames() {
        if (this.myAdditionalPackageNames == null) {
            this.myAdditionalPackageNames = new TreeSet<RepoPackage>();
            for (String url : PyPackageService.getInstance().additionalRepositories) {
                try {
                    for (String pyPackage : PyPIPackageUtil.getPackageNames(url)) {
                        if (pyPackage.contains(" ")) continue;
                        this.myAdditionalPackageNames.add(new RepoPackage(pyPackage, url));
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        return this.myAdditionalPackageNames;
    }

    public void addPackageDetails(@NonNls String packageName, Hashtable details) {
        this.packageToDetails.put(packageName, details);
    }

    @Nullable
    public Hashtable getPackageDetails(@NonNls String packageName) {
        if (this.packageToDetails.containsKey(packageName)) {
            return this.packageToDetails.get(packageName);
        }
        return null;
    }

    public void fillPackageDetails(@NonNls String packageName, AsyncCallback callback) {
        Hashtable details = this.getPackageDetails(packageName);
        if (details == null) {
            Vector<String> params = new Vector<String>();
            params.add(packageName);
            try {
                params.add(PyPIPackageUtil.getPyPIPackages().get(packageName));
                this.myXmlRpcClient.executeAsync("release_data", params, callback);
            }
            catch (Exception ignored) {
                LOG.info((Throwable)ignored);
            }
        } else {
            callback.handleResult((Object)details, null, "");
        }
    }

    public void addPackageReleases(@NotNull String packageName, @NotNull List<String> releases) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/python/packaging/PyPIPackageUtil", "addPackageReleases"));
        }
        if (releases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "releases", "com/jetbrains/python/packaging/PyPIPackageUtil", "addPackageReleases"));
        }
        this.packageToReleases.put(packageName, releases);
    }

    public void usePackageReleases(@NonNls String packageName, AsyncCallback callback) {
        List<String> releases = this.getPackageReleases(packageName);
        if (releases == null) {
            Vector<String> params = new Vector<String>();
            params.add(packageName);
            this.myXmlRpcClient.executeAsync("package_releases", params, callback);
        } else {
            callback.handleResult(releases, null, "");
        }
    }

    @Nullable
    public List<String> getPackageReleases(@NonNls String packageName) {
        if (this.packageToReleases.containsKey(packageName)) {
            return this.packageToReleases.get(packageName);
        }
        return null;
    }

    private PyPIPackageUtil() {
        try {
            PyPIXmlRpcTransportFactory factory = new PyPIXmlRpcTransportFactory(new URL(PYPI_URL));
            factory.setProperty("timeout", 1000);
            this.myXmlRpcClient = new XmlRpcClient(new URL(PYPI_URL), (XmlRpcTransportFactory)factory);
        }
        catch (MalformedURLException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void updatePyPICache(PyPackageService service) throws IOException {
        this.parsePyPIList(this.getPyPIListFromWeb(), service);
    }

    public void parsePyPIList(List<String> packages, PyPackageService service) {
        this.myPackageNames = null;
        for (String pyPackage : packages) {
            try {
                Matcher matcher = this.PYPI_PATTERN.matcher(URLDecoder.decode(pyPackage, "UTF-8"));
                if (!matcher.find()) continue;
                String packageName = matcher.group(1);
                String packageVersion = matcher.group(2);
                if (packageName.contains(" ")) continue;
                service.PY_PACKAGES.put(packageName, packageVersion);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    @Nullable
    public List<String> getPyPIListFromWeb() {
        return (List)HttpRequests.request((String)PYPI_LIST_URL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<String>>(){

            public List<String> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/python/packaging/PyPIPackageUtil$2", "process"));
                }
                final ArrayList<String> packages = new ArrayList<String>();
                BufferedReader reader = request.getReader();
                new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                    boolean inTable = false;

                    @Override
                    public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
                        if ("table".equals(tag.toString())) {
                            boolean bl = this.inTable = !this.inTable;
                        }
                        if (this.inTable && "a".equals(tag.toString())) {
                            packages.add(String.valueOf(set.getAttribute(HTML.Attribute.HREF)));
                        }
                    }

                    @Override
                    public void handleEndTag(HTML.Tag tag, int i) {
                        if ("table".equals(tag.toString())) {
                            this.inTable = !this.inTable;
                        }
                    }
                }, true);
                return packages;
            }
        }, Collections.emptyList(), LOG);
    }

    public Collection<String> getPackageNames() {
        Map<String, String> pyPIPackages = PyPIPackageUtil.getPyPIPackages();
        ArrayList list = Lists.newArrayList(pyPIPackages.keySet());
        Collections.sort(list);
        return list;
    }

    public Map<String, String> loadAndGetPackages() throws IOException {
        Map<String, String> pyPIPackages = PyPIPackageUtil.getPyPIPackages();
        if (pyPIPackages.isEmpty()) {
            this.updatePyPICache(PyPackageService.getInstance());
            pyPIPackages = PyPIPackageUtil.getPyPIPackages();
        }
        return pyPIPackages;
    }

    public static Map<String, String> getPyPIPackages() {
        return PyPackageService.getInstance().PY_PACKAGES;
    }

    public boolean isInPyPI(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/python/packaging/PyPIPackageUtil", "isInPyPI"));
        }
        if (this.myPackageNames == null) {
            HashSet<String> names = new HashSet<String>();
            for (String name : PyPIPackageUtil.getPyPIPackages().keySet()) {
                names.add(name.toLowerCase(Locale.ENGLISH));
            }
            this.myPackageNames = names;
        }
        return this.myPackageNames != null && this.myPackageNames.contains(packageName.toLowerCase(Locale.ENGLISH));
    }

    private static class PyPITrustManager
    implements X509TrustManager {
        private PyPITrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    private static class PyPIXmlRpcTransportFactory
    extends DefaultXmlRpcTransportFactory {
        public PyPIXmlRpcTransportFactory(URL url) {
            super(url);
        }

        public XmlRpcTransport createTransport() throws XmlRpcClientException {
            return new PyPIXmlRpcTransport(this.url);
        }
    }

    private static class PyPIXmlRpcTransport
    extends DefaultXmlRpcTransport {
        public PyPIXmlRpcTransport(URL url) {
            super(url);
        }

        public InputStream sendXmlRpc(byte[] request) throws IOException {
            TrustManager[] trustAllCerts = new TrustManager[]{new PyPITrustManager()};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                HttpConfigurable settings = HttpConfigurable.getInstance();
                this.con = settings.openConnection(PyPIPackageUtil.PYPI_LIST_URL);
                if (this.con instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)this.con).setSSLSocketFactory(sslContext.getSocketFactory());
                }
                this.con.setDoInput(true);
                this.con.setDoOutput(true);
                this.con.setUseCaches(false);
                this.con.setAllowUserInteraction(false);
                this.con.setRequestProperty("Content-Length", Integer.toString(request.length));
                this.con.setRequestProperty("Content-Type", "text/xml");
                if (this.auth != null) {
                    this.con.setRequestProperty("Authorization", "Basic " + this.auth);
                }
                OutputStream out = this.con.getOutputStream();
                out.write(request);
                out.flush();
                out.close();
                return this.con.getInputStream();
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn(e.getMessage());
            }
            catch (KeyManagementException e) {
                LOG.warn(e.getMessage());
            }
            return super.sendXmlRpc(request);
        }
    }
}

