/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyExecutionFix;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyExecutionException
extends ExecutionException {
    @NotNull
    private String myCommand;
    @NotNull
    private List<String> myArgs;
    @NotNull
    private final String myStdout;
    @NotNull
    private final String myStderr;
    private final int myExitCode;
    @NotNull
    private final List<? extends PyExecutionFix> myFixes;

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        this(message, command, args, "", "", 0, Collections.emptyList());
    }

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args, @NotNull ProcessOutput output) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        this(message, command, args, output.getStdout(), output.getStderr(), output.getExitCode(), Collections.emptyList());
    }

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args, @NotNull String stdout, @NotNull String stderr, int exitCode, @NotNull List<? extends PyExecutionFix> fixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (stdout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (stderr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stderr", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/jetbrains/python/packaging/PyExecutionException", "<init>"));
        }
        super(message);
        this.myCommand = command;
        this.myArgs = args;
        this.myStdout = stdout;
        this.myStderr = stderr;
        this.myExitCode = exitCode;
        this.myFixes = fixes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("The following command was executed:\n\n");
        String command = this.getCommand() + " " + StringUtil.join(this.getArgs(), (String)" ");
        b.append(command);
        b.append("\n\n");
        b.append("The error output of the command:\n\n");
        b.append(this.myStdout);
        b.append("\n");
        b.append(this.myStderr);
        return b.toString();
    }

    @NotNull
    public String getCommand() {
        String string = this.myCommand;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyExecutionException", "getCommand"));
        }
        return string;
    }

    @NotNull
    public List<String> getArgs() {
        List<String> list = this.myArgs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyExecutionException", "getArgs"));
        }
        return list;
    }

    @NotNull
    public List<? extends PyExecutionFix> getFixes() {
        List<? extends PyExecutionFix> list = this.myFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyExecutionException", "getFixes"));
        }
        return list;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @NotNull
    public String getStdout() {
        String string = this.myStdout;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyExecutionException", "getStdout"));
        }
        return string;
    }

    @NotNull
    public String getStderr() {
        String string = this.myStderr;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyExecutionException", "getStderr"));
        }
        return string;
    }
}

