/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.actions;

import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.platform.DirectoryProjectGenerator;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonBaseProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.actions.GenerateProjectCallback;
import com.jetbrains.python.newProject.actions.PluginSpecificProjectsStep;
import com.jetbrains.python.newProject.actions.ProjectSpecificAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCharmNewProjectStep
extends DefaultActionGroup
implements DumbAware {
    public PyCharmNewProjectStep(@NotNull String name, @Nullable Runnable runnable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/newProject/actions/PyCharmNewProjectStep", "<init>"));
        }
        this(name, runnable, false);
    }

    public PyCharmNewProjectStep(@NotNull String name, @Nullable Runnable runnable, boolean isWelcomeScreen) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/newProject/actions/PyCharmNewProjectStep", "<init>"));
        }
        super(name, true);
        GenerateProjectCallback callback = new GenerateProjectCallback(runnable);
        ProjectSpecificAction action = new ProjectSpecificAction(callback, new PythonBaseProjectGenerator(), isWelcomeScreen);
        this.add((AnAction)action);
        DirectoryProjectGenerator[] generators = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
        if (generators.length == 0) {
            action.setPopup(false);
        }
        Arrays.sort(generators, new Comparator<DirectoryProjectGenerator>(){

            @Override
            public int compare(DirectoryProjectGenerator o1, DirectoryProjectGenerator o2) {
                if (o1 instanceof PyFrameworkProjectGenerator && !(o2 instanceof PyFrameworkProjectGenerator)) {
                    return -1;
                }
                if (!(o1 instanceof PyFrameworkProjectGenerator) && o2 instanceof PyFrameworkProjectGenerator) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList pluginSpecificGenerators = Lists.newArrayList();
        for (DirectoryProjectGenerator generator : generators) {
            if (generator instanceof PythonProjectGenerator) {
                this.add((AnAction)new ProjectSpecificAction(callback, generator, isWelcomeScreen));
                continue;
            }
            pluginSpecificGenerators.add(generator);
        }
        if (!pluginSpecificGenerators.isEmpty()) {
            this.add((AnAction)new PluginSpecificProjectsStep(callback, pluginSpecificGenerators, isWelcomeScreen));
        }
    }

    public PyCharmNewProjectStep() {
        this("Select Project Type", null, true);
    }
}

