/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.actions;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.NullableConsumer;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.actions.AbstractProjectSettingsStep;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSpecificSettingsStep
extends AbstractProjectSettingsStep
implements DumbAware {
    public ProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator projectGenerator, @NotNull NullableConsumer<AbstractProjectSettingsStep> callback, boolean isWelcomeScreen) {
        if (projectGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectGenerator", "com/jetbrains/python/newProject/actions/ProjectSpecificSettingsStep", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/newProject/actions/ProjectSpecificSettingsStep", "<init>"));
        }
        super(projectGenerator, callback, isWelcomeScreen);
    }

    @Override
    @Nullable
    protected JPanel createAdvancedSettings() {
        JComponent advancedSettings = null;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            advancedSettings = ((PythonProjectGenerator)((Object)this.myProjectGenerator)).getSettingsPanel(this.myProjectDirectory);
        } else if (this.myProjectGenerator instanceof WebProjectTemplate) {
            advancedSettings = ((WebProjectTemplate)this.myProjectGenerator).getPeer().getComponent();
        }
        if (advancedSettings != null) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            HideableDecorator deco = new HideableDecorator(jPanel, "Mor&e Settings", false);
            boolean isValid = this.checkValid();
            deco.setOn(!isValid);
            if (this.myProjectGenerator instanceof PythonProjectGenerator && !deco.isExpanded()) {
                ValidationResult result = ((PythonProjectGenerator)((Object)this.myProjectGenerator)).warningValidation(this.getSdk());
                deco.setOn(!result.isOk());
            }
            deco.setContentComponent(advancedSettings);
            return jPanel;
        }
        return null;
    }
}

