/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.actions;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.NullableConsumer;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.actions.AbstractProjectSettingsStep;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateProjectCallback
implements NullableConsumer<AbstractProjectSettingsStep> {
    private static final Logger LOG = Logger.getInstance(GenerateProjectCallback.class);
    @Nullable
    private final Runnable myRunnable;

    public GenerateProjectCallback(@Nullable Runnable runnable) {
        this.myRunnable = runnable;
    }

    public void consume(@Nullable AbstractProjectSettingsStep settingsStep) {
        Project newProject;
        if (this.myRunnable != null) {
            this.myRunnable.run();
        }
        if (settingsStep == null) {
            return;
        }
        Sdk sdk = settingsStep.getSdk();
        Project project = ProjectManager.getInstance().getDefaultProject();
        ProjectSdksModel model = PyConfigurableInterpreterList.getInstance(project).getModel();
        if (sdk instanceof PyDetectedSdk) {
            final String name = sdk.getName();
            VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath(name);
                }
            });
            PySdkService.getInstance().solidifySdk(sdk);
            sdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, PythonSdkType.getInstance(), true, null, null);
            model.addSdk(sdk);
            settingsStep.setSdk(sdk);
            try {
                model.apply();
            }
            catch (ConfigurationException exception) {
                LOG.error("Error adding detected python interpreter " + exception.getMessage());
            }
        }
        if ((newProject = GenerateProjectCallback.generateProject(project, settingsStep)) != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(newProject, sdk);
            List<Sdk> sdks = PythonSdkType.getAllSdks();
            for (Sdk s : sdks) {
                SdkAdditionalData additionalData = s.getSdkAdditionalData();
                if (!(additionalData instanceof PythonSdkAdditionalData)) continue;
                ((PythonSdkAdditionalData)additionalData).reassociateWithCreatedProject(newProject);
            }
        }
    }

    @Nullable
    private static Project generateProject(@NotNull Project project, final @NotNull AbstractProjectSettingsStep settings) {
        int rc;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/newProject/actions/GenerateProjectCallback", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/python/newProject/actions/GenerateProjectCallback", "generateProject"));
        }
        final DirectoryProjectGenerator generator = settings.getProjectGenerator();
        final File location = new File(settings.getProjectLocation());
        if (!location.exists() && !location.mkdirs()) {
            Messages.showErrorDialog((Project)project, (String)("Cannot create directory '" + location + "'"), (String)"Create Project");
            return null;
        }
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        LOG.assertTrue(baseDir != null, (Object)("Couldn't find '" + location + "' in VFS"));
        baseDir.refresh(false, true);
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)project, (String)("The directory '" + location + "' is not empty. Would you like to create a project from existing sources instead?"), (String)"Create New Project", (Icon)Messages.getQuestionIcon())) == 0) {
            return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        }
        String generatorName = generator == null ? "empty" : ConvertUsagesUtil.ensureProperKey(generator.getName());
        UsageTrigger.trigger("NewDirectoryProjectAction." + generatorName);
        GeneralSettings.getInstance().setLastProjectCreationLocation(location.getParent());
        return PlatformProjectOpenProcessor.doOpenProject(baseDir, null, false, -1, new ProjectOpenedCallback(){

            public void projectOpened(Project project, Module module) {
                if (generator != null) {
                    Object projectSettings = null;
                    if (generator instanceof PythonProjectGenerator) {
                        projectSettings = ((PythonProjectGenerator)((Object)generator)).getProjectSettings();
                    } else if (generator instanceof WebProjectTemplate) {
                        projectSettings = ((WebProjectTemplate)generator).getPeer().getSettings();
                    }
                    if (projectSettings instanceof PyNewProjectSettings) {
                        ((PyNewProjectSettings)projectSettings).setSdk(settings.getSdk());
                        ((PyNewProjectSettings)projectSettings).setInstallFramework(settings.installFramework());
                    }
                    generator.generateProject(project, baseDir, projectSettings, module);
                }
            }
        }, false);
    }
}

