/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonSdkChooserCombo;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.VirtualEnvProjectFilter;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectSettingsStep
extends AbstractActionWithPanel
implements DumbAware {
    protected final DirectoryProjectGenerator myProjectGenerator;
    private final NullableConsumer<AbstractProjectSettingsStep> myCallback;
    private final boolean myIsWelcomeScreen;
    private PythonSdkChooserCombo mySdkCombo;
    private boolean myInstallFramework;
    private TextFieldWithBrowseButton myLocationField;
    protected final File myProjectDirectory;
    private Button myCreateButton;
    private JLabel myErrorLabel;
    private AnAction myCreateAction;
    private Sdk mySdk;

    public AbstractProjectSettingsStep(DirectoryProjectGenerator projectGenerator, NullableConsumer<AbstractProjectSettingsStep> callback, boolean isWelcomeScreen) {
        this.myProjectGenerator = projectGenerator;
        this.myCallback = callback;
        this.myIsWelcomeScreen = isWelcomeScreen;
        this.myProjectDirectory = FileUtil.findSequentNonexistentFile((File)new File(ProjectUtil.getBaseDir()), (String)"untitled", (String)"");
        this.myCreateAction = new AnAction("Create", "Create Project", this.getIcon()){

            public void actionPerformed(AnActionEvent e) {
                boolean isValid = AbstractProjectSettingsStep.this.checkValid();
                if (isValid && AbstractProjectSettingsStep.this.myCallback != null) {
                    AbstractProjectSettingsStep.this.myCallback.consume((Object)AbstractProjectSettingsStep.this);
                }
            }
        };
    }

    public void actionPerformed(AnActionEvent e) {
    }

    @Override
    public JPanel createPanel() {
        this.initGeneratorListeners();
        JPanel basePanel = this.createBasePanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel scrollPanel = new JPanel(new BorderLayout());
        DirectoryProjectGenerator[] generators = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
        int height = generators.length == 0 && !this.myIsWelcomeScreen ? 150 : 400;
        mainPanel.setPreferredSize(new Dimension(mainPanel.getPreferredSize().width, height));
        this.myErrorLabel = new JLabel("");
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.myCreateButton = new Button(this.myCreateAction, this.myCreateAction.getTemplatePresentation());
        scrollPanel.add((Component)basePanel, "North");
        JPanel advancedSettings = this.createAdvancedSettings();
        if (advancedSettings != null) {
            scrollPanel.add((Component)advancedSettings, "Center");
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)scrollPanel, 20, 31);
        scrollPane.setBorder(null);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.myErrorLabel, "North");
        bottomPanel.add((Component)this.myCreateButton, "East");
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    private void initGeneratorListeners() {
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            ((WebProjectTemplate)this.myProjectGenerator).getPeer().addSettingsStateListener(new WebProjectGenerator.SettingsStateListener(){

                @Override
                public void stateChanged(boolean validSettings) {
                    AbstractProjectSettingsStep.this.checkValid();
                }
            });
        } else if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)((Object)this.myProjectGenerator)).addSettingsStateListener(new PythonProjectGenerator.SettingsListener(){

                @Override
                public void stateChanged() {
                    AbstractProjectSettingsStep.this.checkValid();
                }
            });
        }
    }

    protected Icon getIcon() {
        return this.myProjectGenerator.getLogo();
    }

    private JPanel createBasePanel() {
        Sdk python2Sdk;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.myLocationField = new TextFieldWithBrowseButton();
        this.myLocationField.setText(this.myProjectDirectory.toString());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocationField.addBrowseFolderListener("Select base directory", "Select base directory for the Project", null, descriptor);
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (AbstractProjectSettingsStep.this.myProjectGenerator instanceof PythonProjectGenerator) {
                    int ind;
                    String path = AbstractProjectSettingsStep.this.myLocationField.getText().trim();
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - File.separator.length());
                    }
                    if ((ind = path.lastIndexOf(File.separator)) != -1) {
                        String projectName = path.substring(ind + 1, path.length());
                        ((PythonProjectGenerator)((Object)AbstractProjectSettingsStep.this.myProjectGenerator)).locationChanged(projectName);
                    }
                }
            }
        });
        JLabel locationLabel = new JLabel("Location:");
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)locationLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        panel.add((Component)this.myLocationField, c);
        JLabel interpreterLabel = new JLabel("Interpreter:", 2){

            @Override
            public Dimension getMinimumSize() {
                return new JLabel("Project name:").getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        panel.add((Component)interpreterLabel, c);
        Project project = ProjectManager.getInstance().getDefaultProject();
        List<Sdk> sdks = PyConfigurableInterpreterList.getInstance(project).getAllPythonSdks();
        VirtualEnvProjectFilter.removeAllAssociated(sdks);
        Sdk compatibleSdk = sdks.isEmpty() ? null : sdks.iterator().next();
        DirectoryProjectGenerator generator = this.getProjectGenerator();
        if (generator instanceof PyFrameworkProjectGenerator && !((PyFrameworkProjectGenerator)generator).supportsPython3() && compatibleSdk != null && PythonSdkType.getLanguageLevelForSdk(compatibleSdk).isPy3K() && (python2Sdk = PythonSdkType.findPython2Sdk(sdks)) != null) {
            compatibleSdk = python2Sdk;
        }
        final Sdk preferred = compatibleSdk;
        this.mySdkCombo = new PythonSdkChooserCombo(project, sdks, new Condition<Sdk>(){

            public boolean value(Sdk sdk) {
                return sdk == preferred;
            }
        });
        this.mySdkCombo.setButtonIcon(PythonIcons.Python.InterpreterGear);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        panel.add((Component)((Object)this.mySdkCombo), c);
        JPanel basePanelExtension = this.extendBasePanel();
        if (basePanelExtension != null) {
            c.gridwidth = 2;
            c.gridy = 2;
            c.gridx = 0;
            panel.add((Component)basePanelExtension, c);
        }
        this.registerValidators();
        return panel;
    }

    @Nullable
    protected JPanel extendBasePanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            return ((PythonProjectGenerator)((Object)this.myProjectGenerator)).extendBasePanel();
        }
        return null;
    }

    protected void registerValidators() {
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                AbstractProjectSettingsStep.this.checkValid();
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractProjectSettingsStep.this.checkValid();
            }
        };
        this.mySdkCombo.getComboBox().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                AbstractProjectSettingsStep.this.checkValid();
            }
        });
        this.myLocationField.getTextField().addActionListener(listener);
        this.mySdkCombo.getComboBox().addActionListener(listener);
        this.mySdkCombo.addActionListener(listener);
    }

    public boolean checkValid() {
        Sdk sdk;
        boolean isPy3k;
        if (this.myLocationField == null) {
            return true;
        }
        String projectName = this.myLocationField.getText();
        this.setErrorText(null);
        this.myInstallFramework = false;
        if (projectName.trim().isEmpty()) {
            this.setErrorText("Project name can't be empty");
            return false;
        }
        if (this.myLocationField.getText().indexOf(36) >= 0) {
            this.setErrorText("Project directory name must not contain the $ character");
            return false;
        }
        if (this.myProjectGenerator != null) {
            WebProjectGenerator.GeneratorPeer peer;
            ValidationInfo validationInfo;
            ValidationResult warningResult;
            String baseDirPath = this.myLocationField.getTextField().getText();
            ValidationResult validationResult = this.myProjectGenerator.validate(baseDirPath);
            if (!validationResult.isOk()) {
                this.setErrorText(validationResult.getErrorMessage());
                return false;
            }
            if (this.myProjectGenerator instanceof PythonProjectGenerator && !(warningResult = ((PythonProjectGenerator)((Object)this.myProjectGenerator)).warningValidation(this.getSdk())).isOk()) {
                this.setWarningText(warningResult.getErrorMessage());
            }
            if (this.myProjectGenerator instanceof WebProjectTemplate && (validationInfo = (peer = ((WebProjectTemplate)this.myProjectGenerator).getPeer()).validate()) != null && !peer.isBackgroundJobRunning()) {
                this.setErrorText(validationInfo.message);
                return false;
            }
        }
        boolean bl = isPy3k = (sdk = this.getSdk()) != null && PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K();
        if (sdk != null && PythonSdkType.isRemote(sdk) && !AbstractProjectSettingsStep.acceptsRemoteSdk(this.myProjectGenerator)) {
            this.setErrorText("Please choose a local interpreter");
            return false;
        }
        if (this.myProjectGenerator instanceof PyFrameworkProjectGenerator) {
            PyFrameworkProjectGenerator frameworkProjectGenerator = (PyFrameworkProjectGenerator)this.myProjectGenerator;
            String frameworkName = frameworkProjectGenerator.getFrameworkTitle();
            if (sdk != null && !this.isFrameworkInstalled(sdk)) {
                String warningText = frameworkName + " will be installed on selected interpreter";
                this.myInstallFramework = true;
                PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                boolean hasManagement = false;
                try {
                    hasManagement = packageManager.hasManagement(PySdkUtil.isRemote(sdk));
                }
                catch (ExecutionException ignored) {
                    // empty catch block
                }
                if (!hasManagement) {
                    warningText = "Python packaging tools and " + warningText;
                }
                this.setWarningText(warningText);
            }
            if (isPy3k && !((PyFrameworkProjectGenerator)this.myProjectGenerator).supportsPython3()) {
                this.setErrorText(frameworkName + " is not supported for the selected interpreter");
                return false;
            }
        }
        if (sdk == null) {
            this.setErrorText("No Python interpreter selected");
            return false;
        }
        return true;
    }

    public void setErrorText(@Nullable String text) {
        this.myErrorLabel.setText(text);
        this.myErrorLabel.setForeground(MessageType.ERROR.getTitleForeground());
        this.myErrorLabel.setIcon(text == null ? null : AllIcons.Actions.Lightning);
        this.myCreateButton.setEnabled(text == null);
    }

    public void setWarningText(@Nullable String text) {
        this.myErrorLabel.setText("Note: " + text + "  ");
        this.myErrorLabel.setForeground(MessageType.WARNING.getTitleForeground());
    }

    private static boolean acceptsRemoteSdk(DirectoryProjectGenerator generator) {
        if (generator instanceof PyFrameworkProjectGenerator) {
            return ((PyFrameworkProjectGenerator)generator).acceptsRemoteSdk();
        }
        return true;
    }

    private boolean isFrameworkInstalled(Sdk sdk) {
        PyFrameworkProjectGenerator projectGenerator = (PyFrameworkProjectGenerator)this.getProjectGenerator();
        return projectGenerator != null && projectGenerator.isFrameworkInstalled(sdk);
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        return null;
    }

    public DirectoryProjectGenerator getProjectGenerator() {
        return this.myProjectGenerator;
    }

    public Sdk getSdk() {
        if (this.mySdk != null) {
            return this.mySdk;
        }
        return (Sdk)this.mySdkCombo.getComboBox().getSelectedItem();
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public String getProjectLocation() {
        return this.myLocationField.getText();
    }

    public void setLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/newProject/actions/AbstractProjectSettingsStep", "setLocation"));
        }
        this.myLocationField.setText(location);
    }

    public boolean installFramework() {
        return this.myInstallFramework;
    }

    private static class Button
    extends ActionButtonWithText {
        private final Border myBorder;

        public Button(AnAction action, Presentation presentation) {
            super(action, presentation, "NewProject", new Dimension(70, 50));
            LineBorder border = new LineBorder(JBColor.border(), 1, true);
            this.myBorder = UIUtil.isUnderDarcula() ? UIUtil.getButtonBorder() : border;
            this.setBorder(this.myBorder);
        }

        @Override
        protected int iconTextSpace() {
            return 8;
        }

        @Override
        public boolean isFocusable() {
            return true;
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
            } else if (e.getID() == 1005) {
                this.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, 0, 0, 0, false));
            }
        }

        @Override
        public Insets getInsets() {
            return new Insets(5, 10, 5, 5);
        }

        @Override
        protected int horizontalTextAlignment() {
            return 2;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 504) {
                this.setBorder(null);
            } else if (e.getID() == 505) {
                this.setBorder(this.myBorder);
            }
        }
    }
}

