/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonProjectGenerator {
    private final List<SettingsListener> myListeners = ContainerUtil.newArrayList();

    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        return null;
    }

    @Nullable
    public JPanel extendBasePanel() throws ProcessCanceledException {
        return null;
    }

    public Object getProjectSettings() {
        return new PyNewProjectSettings();
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        return ValidationResult.OK;
    }

    public void addSettingsStateListener(@NotNull SettingsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/python/newProject/PythonProjectGenerator", "addSettingsStateListener"));
        }
        this.myListeners.add(listener);
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLocation", "com/jetbrains/python/newProject/PythonProjectGenerator", "locationChanged"));
        }
    }

    public void fireStateChanged() {
        for (SettingsListener listener : this.myListeners) {
            listener.stateChanged();
        }
    }

    public static interface SettingsListener {
        public void stateChanged();
    }
}

