/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.remote.RemoteSdkCredentials;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.RemoteProjectSettings;
import icons.PythonIcons;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonBaseProjectGenerator
extends PythonProjectGenerator
implements DirectoryProjectGenerator {
    @Override
    @NotNull
    @Nls
    public String getName() {
        if ("Pure Python" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "getName"));
        }
        return "Pure Python";
    }

    @Nullable
    public Object showGenerationSettings(VirtualFile baseDir) throws ProcessCanceledException {
        return null;
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        return null;
    }

    @Override
    public Object getProjectSettings() {
        return new PyNewProjectSettings();
    }

    @Override
    @Nullable
    public Icon getLogo() {
        return PythonIcons.Python.Python_logo;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, final Object settings, final @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "generateProject"));
        }
        if (settings instanceof RemoteProjectSettings) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            assert (manager != null);
            manager.createDeployment(project, baseDir, (RemoteProjectSettings)settings, (RemoteSdkCredentials)((RemoteProjectSettings)settings).getSdk().getSdkAdditionalData());
        } else if (settings instanceof PyNewProjectSettings) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModuleRootModificationUtil.setModuleSdk(module, ((PyNewProjectSettings)settings).getSdk());
                }
            });
        }
    }

    @Override
    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirPath", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "validate"));
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/newProject/PythonBaseProjectGenerator", "validate"));
        }
        return validationResult;
    }
}

