/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.nameResolver;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NameResolverTools {
    private static final PsiCacheKey<Pair<String, String>, PyElement> QUALIFIED_AND_CLASS_NAME = PsiCacheKey.create((String)NameResolverTools.class.getName(), (Function)new QualifiedAndClassNameObtainer(), (Key)PsiModificationTracker.MODIFICATION_COUNT);

    private NameResolverTools() {
    }

    public static boolean isElementWithName(@NotNull Collection<? extends PyElement> elements, FQNamesProvider ... namesProviders) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/nameResolver/NameResolverTools", "isElementWithName"));
        }
        if (namesProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesProviders", "com/jetbrains/python/nameResolver/NameResolverTools", "isElementWithName"));
        }
        for (PyElement pyElement : elements) {
            if (!NameResolverTools.isName(pyElement, namesProviders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isName(@NotNull PyElement element, FQNamesProvider ... namesProviders) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/nameResolver/NameResolverTools", "isName"));
        }
        if (namesProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesProviders", "com/jetbrains/python/nameResolver/NameResolverTools", "isName"));
        }
        Pair qualifiedAndClassName = (Pair)QUALIFIED_AND_CLASS_NAME.getValue((PsiElement)element);
        String qualifiedName = (String)qualifiedAndClassName.first;
        String className = (String)qualifiedAndClassName.second;
        for (FQNamesProvider provider : namesProviders) {
            List<String> names = Arrays.asList(provider.getNames());
            if (qualifiedName != null && names.contains(qualifiedName)) {
                return true;
            }
            if (className == null || !provider.isClass() || !names.contains(className)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PyCallExpression findCallExpParent(@NotNull PsiElement anchor, @NotNull FQNamesProvider functionName) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/nameResolver/NameResolverTools", "findCallExpParent"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/jetbrains/python/nameResolver/NameResolverTools", "findCallExpParent"));
        }
        PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)anchor, (Condition)new MyFunctionCondition(functionName));
        if (parent instanceof PyCallExpression) {
            return (PyCallExpression)parent;
        }
        return null;
    }

    private static class QualifiedAndClassNameObtainer
    implements Function<PyElement, Pair<String, String>> {
        private QualifiedAndClassNameObtainer() {
        }

        @NotNull
        public Pair<String, String> fun(@NotNull PyElement element) {
            PyClass aClass;
            PsiElement resolvedElement;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/nameResolver/NameResolverTools$QualifiedAndClassNameObtainer", "fun"));
            }
            PyElement elementToCheck = element;
            PsiReference reference = element.getReference();
            if (reference != null && (resolvedElement = reference.resolve()) instanceof PyElement) {
                elementToCheck = (PyElement)resolvedElement;
            }
            String qualifiedName = null;
            if (elementToCheck instanceof PyQualifiedNameOwner) {
                qualifiedName = ((PyQualifiedNameOwner)elementToCheck).getQualifiedName();
            }
            String className = null;
            if (elementToCheck instanceof PyFunction && (aClass = ((PyFunction)elementToCheck).getContainingClass()) != null) {
                className = aClass.getQualifiedName();
            }
            Pair pair = Pair.create((Object)qualifiedName, className);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/nameResolver/NameResolverTools$QualifiedAndClassNameObtainer", "fun"));
            }
            return pair;
        }
    }

    private static class MyFunctionCondition
    implements Condition<PsiElement> {
        @NotNull
        private final FQNamesProvider myNameToSearch;

        MyFunctionCondition(@NotNull FQNamesProvider name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/nameResolver/NameResolverTools$MyFunctionCondition", "<init>"));
            }
            this.myNameToSearch = name;
        }

        public boolean value(PsiElement element) {
            if (element instanceof PyCallExpression) {
                return ((PyCallExpression)element).isCallee(this.myNameToSearch);
            }
            return false;
        }
    }
}

