/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyContentEntriesEditor
extends CommonContentEntriesEditor {
    private static final Color TEMPLATES_COLOR = JBColor.MAGENTA;
    private final MultiMap<ContentEntry, VirtualFilePointer> myTemplateRoots = new MultiMap();
    private final Module myModule;
    private Disposable myFilePointersDisposable;
    private final VirtualFilePointerListener DUMMY_LISTENER = new VirtualFilePointerListener(){

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/jetbrains/python/module/PyContentEntriesEditor$1", "beforeValidityChanged"));
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/jetbrains/python/module/PyContentEntriesEditor$1", "validityChanged"));
            }
        }
    };

    public PyContentEntriesEditor(Module module, ModuleConfigurationState moduleConfigurationState, JpsModuleSourceRootType<?> ... rootTypes) {
        super(module.getName(), moduleConfigurationState, rootTypes);
        this.myModule = module;
        this.reset();
    }

    @Override
    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new MyContentEntryTreeEditor(project, this.getEditHandlers());
    }

    @Override
    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List<ContentEntry> entries = super.addContentEntries(files);
        this.addContentEntryPanels(entries.toArray(new ContentEntry[entries.size()]));
        return entries;
    }

    @Override
    public void reset() {
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
        this.myTemplateRoots.clear();
        this.myFilePointersDisposable = Disposer.newDisposable();
        TemplatesService instance = TemplatesService.getInstance(this.myModule);
        if (instance != null) {
            List<VirtualFile> folders = instance.getTemplateFolders();
            for (VirtualFile folder : folders) {
                ContentEntry contentEntry = this.findContentEntryForFile(folder);
                if (contentEntry == null) continue;
                this.myTemplateRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(folder, this.myFilePointersDisposable, this.DUMMY_LISTENER));
            }
        }
        if (this.myRootTreeEditor != null) {
            ContentEntryEditor editor = this.myRootTreeEditor.getContentEntryEditor();
            if (editor != null) {
                editor.update();
            }
            this.myRootTreeEditor.update();
        }
    }

    @Nullable
    private ContentEntry findContentEntryForFile(VirtualFile virtualFile) {
        for (ContentEntry contentEntry : this.getModel().getContentEntries()) {
            VirtualFile file = contentEntry.getFile();
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        List<VirtualFile> templateRoots = this.getCurrentState();
        TemplatesService.getInstance(this.myModule).setTemplateFolders(templateRoots.toArray(new VirtualFile[templateRoots.size()]));
    }

    private List<VirtualFile> getCurrentState() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry entry : this.myTemplateRoots.keySet()) {
            for (VirtualFilePointer filePointer : this.myTemplateRoots.get((Object)entry)) {
                result.add(filePointer.getFile());
            }
        }
        return result;
    }

    @Override
    public boolean isModified() {
        List<VirtualFile> current;
        List<VirtualFile> original;
        if (super.isModified()) {
            return true;
        }
        TemplatesService templatesService = TemplatesService.getInstance(this.myModule);
        return templatesService != null && !Comparing.haveEqualElements(original = templatesService.getTemplateFolders(), current = this.getCurrentState());
    }

    @Override
    protected MyContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new MyContentEntryEditor(contentEntryUrl, this.getEditHandlers());
    }

    private static class TemplateRootFolder
    extends ContentFolderBaseImpl {
        protected TemplateRootFolder(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
            if (filePointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/jetbrains/python/module/PyContentEntriesEditor$TemplateRootFolder", "<init>"));
            }
            if (contentEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/jetbrains/python/module/PyContentEntriesEditor$TemplateRootFolder", "<init>"));
            }
            super(filePointer, contentEntry);
        }
    }

    private static class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener myListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MyContentEntryTreeEditor.this.update();
            }
        };

        public MyContentEntryTreeEditor(Project project, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(project, handlers);
        }

        @Override
        public void setContentEntryEditor(ContentEntryEditor newEditor) {
            MyContentEntryEditor existingEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)existingEditor, (Object)newEditor)) {
                return;
            }
            if (existingEditor != null) {
                existingEditor.removeListener(this.myListener);
            }
            if (newEditor != null) {
                ((MyContentEntryEditor)newEditor).addListener(this.myListener);
            }
            super.setContentEntryEditor(newEditor);
        }

        @Override
        public MyContentEntryEditor getContentEntryEditor() {
            return (MyContentEntryEditor)super.getContentEntryEditor();
        }

        @Override
        protected void createEditingActions() {
            super.createEditingActions();
            ContentEntryEditingAction a = new ContentEntryEditingAction((JTree)this.myTree){
                {
                    Presentation templatePresentation = this.getTemplatePresentation();
                    templatePresentation.setText("Templates");
                    templatePresentation.setDescription("Template Folders");
                    templatePresentation.setIcon(PythonIcons.Python.TemplateRoot);
                }

                public boolean isSelected(AnActionEvent e) {
                    VirtualFile[] selectedFiles = this.getSelectedFiles();
                    return selectedFiles.length != 0 && MyContentEntryTreeEditor.this.getContentEntryEditor().hasTemplateRoot(selectedFiles[0]);
                }

                public void setSelected(AnActionEvent e, boolean isSelected) {
                    VirtualFile[] selectedFiles = this.getSelectedFiles();
                    assert (selectedFiles.length != 0);
                    for (VirtualFile selectedFile : selectedFiles) {
                        boolean wasSelected = MyContentEntryTreeEditor.this.getContentEntryEditor().hasTemplateRoot(selectedFile);
                        if (isSelected) {
                            if (wasSelected) continue;
                            MyContentEntryTreeEditor.this.getContentEntryEditor().addTemplateRoot(selectedFile);
                            continue;
                        }
                        if (!wasSelected) continue;
                        MyContentEntryTreeEditor.this.getContentEntryEditor().removeTemplateRoot(selectedFile.getUrl());
                    }
                }
            };
            this.myEditingActionsGroup.add((AnAction)a);
            a.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8)), (JComponent)this.myTree);
        }

        @Override
        protected TreeCellRenderer getContentEntryCellRenderer() {
            return new ContentEntryTreeCellRenderer(this, this.getEditHandlers()){

                @Override
                protected Icon updateIcon(ContentEntry entry, VirtualFile file, Icon originalIcon) {
                    if (MyContentEntryTreeEditor.this.getContentEntryEditor().hasTemplateRoot(file)) {
                        return PythonIcons.Python.TemplateRoot;
                    }
                    return super.updateIcon(entry, file, originalIcon);
                }
            };
        }
    }

    protected class MyContentEntryEditor
    extends ContentEntryEditor {
        private final EventDispatcher<ChangeListener> myEventDispatcher;

        public MyContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(contentEntryUrl, handlers);
            this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        }

        @Override
        protected ModifiableRootModel getModel() {
            return PyContentEntriesEditor.this.getModel();
        }

        public void addListener(ChangeListener changeListener) {
            this.myEventDispatcher.addListener((EventListener)changeListener);
        }

        public void removeListener(ChangeListener changeListener) {
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        @Override
        protected ContentRootPanel createContentRootPane() {
            return new MyContentRootPanel();
        }

        @Override
        public void deleteContentFolder(ContentEntry contentEntry, ContentFolder folder) {
            if (folder instanceof TemplateRootFolder) {
                this.removeTemplateRoot(folder.getUrl());
            } else {
                super.deleteContentFolder(contentEntry, folder);
            }
        }

        public void addTemplateRoot(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor", "addTemplateRoot"));
            }
            VirtualFilePointer root = VirtualFilePointerManager.getInstance().create(file, PyContentEntriesEditor.this.myFilePointersDisposable, PyContentEntriesEditor.this.DUMMY_LISTENER);
            PyContentEntriesEditor.this.myTemplateRoots.putValue((Object)this.getContentEntry(), (Object)root);
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            this.update();
        }

        public void removeTemplateRoot(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor", "removeTemplateRoot"));
            }
            VirtualFilePointer root = this.getTemplateRoot(url);
            if (root != null) {
                PyContentEntriesEditor.this.myTemplateRoots.remove((Object)this.getContentEntry(), (Object)root);
                ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
                this.update();
            }
        }

        public boolean hasTemplateRoot(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor", "hasTemplateRoot"));
            }
            return this.getTemplateRoot(file.getUrl()) != null;
        }

        @Nullable
        public VirtualFilePointer getTemplateRoot(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor", "getTemplateRoot"));
            }
            for (VirtualFilePointer filePointer : PyContentEntriesEditor.this.myTemplateRoots.get((Object)this.getContentEntry())) {
                if (!Comparing.equal((String)filePointer.getUrl(), (String)url)) continue;
                return filePointer;
            }
            return null;
        }

        protected class MyContentRootPanel
        extends ContentRootPanel {
            public MyContentRootPanel() {
                super(MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
            }

            @Override
            @NotNull
            protected ContentEntryImpl getContentEntry() {
                ContentEntryImpl contentEntryImpl = (ContentEntryImpl)MyContentEntryEditor.this.getContentEntry();
                if (contentEntryImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
                }
                return contentEntryImpl;
            }

            @Override
            protected void addFolderGroupComponents() {
                super.addFolderGroupComponents();
                if (!PyContentEntriesEditor.this.myTemplateRoots.get((Object)this.getContentEntry()).isEmpty()) {
                    ArrayList<TemplateRootFolder> folders = new ArrayList<TemplateRootFolder>(PyContentEntriesEditor.this.myTemplateRoots.size());
                    for (VirtualFilePointer root : PyContentEntriesEditor.this.myTemplateRoots.get((Object)this.getContentEntry())) {
                        folders.add(new TemplateRootFolder(root, this.getContentEntry()));
                    }
                    JComponent sourcesComponent = this.createFolderGroupComponent("Template Folders", folders.toArray(new ContentFolder[folders.size()]), TEMPLATES_COLOR, null);
                    this.add((Component)sourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                }
            }
        }
    }
}

