/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.magicLiteral;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.jetbrains.python.magicLiteral.PyMagicLiteralExtensionPoint;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyMagicLiteralTools {
    private static final PsiCacheKey<Ref<PyMagicLiteralExtensionPoint>, StringLiteralExpression> MAGIC_LITERAL_POINT = PsiCacheKey.create((String)PyMagicLiteralTools.class.getName(), (Function)new MagicLiteralChecker(), (Key)PsiModificationTracker.MODIFICATION_COUNT);

    private PyMagicLiteralTools() {
    }

    public static boolean isMagicLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/magicLiteral/PyMagicLiteralTools", "isMagicLiteral"));
        }
        return element instanceof StringLiteralExpression && PyMagicLiteralTools.getPoint((StringLiteralExpression)element) != null;
    }

    @Nullable
    public static PyMagicLiteralExtensionPoint getPoint(@NotNull StringLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/magicLiteral/PyMagicLiteralTools", "getPoint"));
        }
        return (PyMagicLiteralExtensionPoint)((Ref)MAGIC_LITERAL_POINT.getValue((PsiElement)element)).get();
    }

    private static class MagicLiteralChecker
    implements Function<StringLiteralExpression, Ref<PyMagicLiteralExtensionPoint>> {
        private MagicLiteralChecker() {
        }

        public Ref<PyMagicLiteralExtensionPoint> fun(StringLiteralExpression element) {
            PyMagicLiteralExtensionPoint[] magicLiteralExtPoints;
            for (PyMagicLiteralExtensionPoint magicLiteralExtensionPoint : magicLiteralExtPoints = (PyMagicLiteralExtensionPoint[])ApplicationManager.getApplication().getExtensions(PyMagicLiteralExtensionPoint.EP_NAME)) {
                if (!magicLiteralExtensionPoint.isMagicLiteral(element)) continue;
                return Ref.create((Object)magicLiteralExtensionPoint);
            }
            return new Ref();
        }
    }
}

