/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.magicLiteral;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMagicLiteralRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        PsiElement element = PyMagicLiteralRenameHandler.getElement(file, editor);
        return element != null && PyMagicLiteralTools.isMagicLiteral(element);
    }

    @Nullable
    private static PsiElement getElement(PsiFile file, Editor editor) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getCurrentCaret().getOffset());
        if (element instanceof PyStringLiteralExpression) {
            return element;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, StringLiteralExpression.class);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/magicLiteral/PyMagicLiteralRenameHandler", "invoke"));
        }
        PsiElement element = PyMagicLiteralRenameHandler.getElement(file, editor);
        if (element == null) {
            return;
        }
        RenameDialog.showRenameDialog(dataContext, new RenameDialog(project, element, null, editor));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/magicLiteral/PyMagicLiteralRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/magicLiteral/PyMagicLiteralRenameHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }
}

