/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEditorHighlighter
extends LexerEditorHighlighter {
    private Boolean hadUnicodeImport;
    public static final Key<Boolean> KEY = new Key("python.future.import");

    public PythonEditorHighlighter(@NotNull EditorColorsScheme scheme, @Nullable Project project, @Nullable VirtualFile file) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/jetbrains/python/lexer/PythonEditorHighlighter", "<init>"));
        }
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)(file != null ? file.getFileType() : PythonFileType.INSTANCE), (Project)project, (VirtualFile)file), scheme);
        this.hadUnicodeImport = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(DocumentEvent e) {
        PythonEditorHighlighter pythonEditorHighlighter = this;
        synchronized (pythonEditorHighlighter) {
            Document document = e.getDocument();
            Lexer l = this.getLexer();
            if (l instanceof LayeredLexer) {
                Lexer delegate = ((LayeredLexer)l).getDelegate();
                int offset = e.getOffset();
                int lineNumber = document.getLineNumber(offset);
                TextRange tr = new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber));
                document.putUserData(KEY, (Object)(document.getText(tr).indexOf("unicode_literals") == -1 ? 1 : 0));
                Boolean hasUnicodeImport = (Boolean)document.getUserData(KEY);
                if (delegate instanceof PythonHighlightingLexer && (((PythonHighlightingLexer)delegate).getImportOffset() > e.getOffset() || hasUnicodeImport != this.hadUnicodeImport)) {
                    ((PythonHighlightingLexer)delegate).clearState(e.getDocument().getTextLength());
                    this.setText(document.getCharsSequence());
                } else {
                    super.documentChanged(e);
                }
            } else {
                super.documentChanged(e);
            }
        }
    }

    @Override
    public void beforeDocumentChange(DocumentEvent e) {
        Document document = e.getDocument();
        this.hadUnicodeImport = (Boolean)document.getUserData(KEY);
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/lexer/PythonEditorHighlighter", "setEditor"));
        }
        Lexer l = this.getLexer();
        if (l instanceof LayeredLexer) {
            editor.getDocument().putUserData(KEY, (Object)(editor.getDocument().getText().indexOf("unicode_literals") == -1 ? 1 : 0));
        }
        super.setEditor(editor);
    }
}

