/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import org.jetbrains.annotations.NotNull;

public class PyStringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.lexer.PyStringLiteralLexer");
    private static final short BEFORE_FIRST_QUOTE = 0;
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myLastState;
    private int myBufferEnd;
    private char myQuoteChar;
    private boolean myIsRaw;
    private boolean myIsTriple;
    private final IElementType myOriginalLiteralToken;
    private boolean mySeenEscapedSpacesOnly;

    public PyStringLiteralLexer(IElementType originalLiteralToken) {
        this.myOriginalLiteralToken = originalLiteralToken;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/python/lexer/PyStringLiteralLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myState = initialState;
        this.myLastState = initialState;
        this.mySeenEscapedSpacesOnly = true;
        this.myBufferEnd = endOffset;
        int i = this.myStart;
        int offset = PyStringLiteralLexer.skipRawPrefix(buffer, i = PyStringLiteralLexer.skipEncodingPrefix(buffer, i));
        if (offset > i) {
            this.myIsRaw = true;
        }
        i = offset;
        offset = PyStringLiteralLexer.skipRawPrefix(buffer, i = PyStringLiteralLexer.skipEncodingPrefix(buffer, i));
        if (offset > i) {
            this.myIsRaw = true;
        }
        i = offset;
        char c = buffer.charAt(i);
        assert (c == '\"' || c == '\'') : "String must be quoted by single or double quote. Found '" + c + "' in string " + buffer;
        this.myQuoteChar = c;
        this.myIsTriple = buffer.length() > i + 2 && buffer.charAt(i + 1) == c && buffer.charAt(i + 2) == c;
        this.myEnd = this.locateToken(this.myStart);
    }

    public static int skipRawPrefix(CharSequence text, int startOffset) {
        char c = Character.toUpperCase(text.charAt(startOffset));
        if (c == 'R') {
            ++startOffset;
        }
        return startOffset;
    }

    public static int skipEncodingPrefix(CharSequence text, int startOffset) {
        char c = Character.toUpperCase(text.charAt(startOffset));
        if (c == 'U' || c == 'B' || c == 'C') {
            ++startOffset;
        }
        return startOffset;
    }

    public int getState() {
        return this.myLastState;
    }

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\' || this.myIsRaw && (!this.isUnicodeMode() || !this.nextIsUnicodeEscape())) {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        if (this.myStart + 1 >= this.myEnd) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2))) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u' || nextChar == 'U') {
            if (this.isUnicodeMode()) {
                int width = nextChar == 'u' ? 4 : 8;
                for (int i = this.myStart + 2; i < this.myStart + width + 2; ++i) {
                    if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
            return this.myOriginalLiteralToken;
        }
        if (nextChar == 'x') {
            for (int i = this.myStart + 2; i < this.myStart + 4; ++i) {
                if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'N' && this.isUnicodeMode()) {
            int i = this.myStart + 2;
            if (i >= this.myEnd || this.myBuffer.charAt(i) != '{') {
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            ++i;
            while (i < this.myEnd && this.myBuffer.charAt(i) != '}') {
                ++i;
            }
            if (i >= this.myEnd) {
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        switch (nextChar) {
            case '\"': 
            case '\'': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '\\': 
            case 'a': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
        }
        return this.myOriginalLiteralToken;
    }

    private boolean nextIsUnicodeEscape() {
        if (this.myStart + 1 < this.myEnd) {
            char nextChar = this.myBuffer.charAt(this.myStart + 1);
            return nextChar == 'u' || nextChar == 'U';
        }
        return false;
    }

    private boolean isUnicodeMode() {
        return PyTokenTypes.UNICODE_NODES.contains(this.myOriginalLiteralToken);
    }

    private boolean isTrailingSpace(int start) {
        for (int i = start; i < this.myBufferEnd; i += 2) {
            char c = this.myBuffer.charAt(i);
            if (c != '\\') {
                return false;
            }
            if (i == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public int getTokenStart() {
        assert (this.myStart < this.myEnd || this.myStart == this.myEnd && this.myEnd == this.myBufferEnd);
        return this.myStart;
    }

    public int getTokenEnd() {
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.error("myStart=" + this.myStart + " myEnd=" + this.myEnd + " myBufferEnd=" + this.myBufferEnd + " text=" + this.myBuffer.subSequence(this.myStart, this.myBufferEnd));
        }
        return this.myEnd;
    }

    private int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i = start;
        if (this.myBuffer.charAt(i) == '\\') {
            LOG.assertTrue(this.myState == 1);
            ++i;
            if (this.myIsRaw) {
                return i;
            }
            if (i == this.myBufferEnd) {
                this.myState = 2;
                return i;
            }
            if (this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                char first = this.myBuffer.charAt(i);
                if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                    ++i;
                }
                return i;
            }
            if (this.myBuffer.charAt(i) == 'x') {
                ++i;
                while (i < start + 4) {
                    if (i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                        return i;
                    }
                    ++i;
                }
                return i;
            }
            if (this.myBuffer.charAt(i) == 'u' || this.myBuffer.charAt(i) == 'U') {
                int width = this.myBuffer.charAt(i) == 'u' ? 4 : 8;
                ++i;
                while (i < start + width + 2) {
                    if (i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                        return i;
                    }
                    ++i;
                }
                return i;
            }
            if (this.myBuffer.charAt(i) == 'N' && this.isUnicodeMode()) {
                ++i;
                while (i < this.myBufferEnd && this.myBuffer.charAt(i) != '}') {
                    ++i;
                }
                if (i < this.myBufferEnd) {
                    ++i;
                }
                return i;
            }
            return i + 1;
        }
        int quote_limit = this.myIsTriple ? 3 : 1;
        int qcnt = 0;
        while (i < this.myBufferEnd) {
            if (this.myBuffer.charAt(i) == '\\' && !this.myIsRaw) {
                return i;
            }
            if (this.myState == 0 && this.myBuffer.charAt(i) == this.myQuoteChar) {
                if (++qcnt == quote_limit) {
                    this.myState = 1;
                    qcnt = 0;
                }
            } else if (!(this.myState != 1 || this.myBuffer.charAt(i) != this.myQuoteChar || this.myIsRaw && this.myBuffer.charAt(i - 1) == '\\')) {
                if (++qcnt == quote_limit) {
                    this.myState = 2;
                    return i + 1;
                }
            } else {
                qcnt = 0;
            }
            ++i;
        }
        return i;
    }

    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.warn("Inconsistent: start " + this.myStart + ", end " + this.myEnd + ", buf end " + this.myBufferEnd);
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/lexer/PyStringLiteralLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }
}

