/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AutoImportHintAction;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.codeInsight.imports.PythonReferenceImporter;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.documentation.DocStringParameterReference;
import com.jetbrains.python.documentation.DocStringTypeReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.inspections.PyUnreachableCodeInspection;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddIgnoredIdentifierQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.GenerateBinaryStubsFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefAddFutureImportQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferenceSkipperExtPoint;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnresolvedReferencesInspection
extends PyInspection {
    private static final Key<Visitor> KEY = Key.create((String)"PyUnresolvedReferencesInspection.Visitor");
    public static final Key<PyUnresolvedReferencesInspection> SHORT_NAME_KEY = Key.create((String)PyUnresolvedReferencesInspection.class.getSimpleName());
    public List<String> ignoredIdentifiers = new ArrayList<String>();

    public static PyUnresolvedReferencesInspection getInstance(PsiElement element) {
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(element.getProject()).getInspectionProfile();
        return (PyUnresolvedReferencesInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME_KEY.toString(), element);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unresolved.refs", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session, this.ignoredIdentifiers);
        Visitor existingVisitor = (Visitor)((Object)session.getUserData(KEY));
        if (existingVisitor == null) {
            session.putUserData(KEY, (Object)visitor);
        }
        Visitor visitor2 = visitor;
        if (visitor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "buildVisitor"));
        }
        return visitor2;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "inspectionFinished"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "inspectionFinished"));
        }
        Visitor visitor = (Visitor)((Object)session.getUserData(KEY));
        assert (visitor != null);
        if (PyCodeInsightSettings.getInstance().HIGHLIGHT_UNUSED_IMPORTS) {
            visitor.highlightUnusedImports();
        }
        session.putUserData(KEY, null);
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore references", this.ignoredIdentifiers);
        return form.getContentPanel();
    }

    private static boolean importShouldBeSkippedByExtPoint(@NotNull PyImportedNameDefiner importNameDefiner) {
        if (importNameDefiner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importNameDefiner", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection", "importShouldBeSkippedByExtPoint"));
        }
        for (PyUnresolvedReferenceSkipperExtPoint skipper : (PyUnresolvedReferenceSkipperExtPoint[])PyUnresolvedReferenceSkipperExtPoint.EP_NAME.getExtensions()) {
            if (!skipper.unusedImportShouldBeSkipped(importNameDefiner)) continue;
            return true;
        }
        return false;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private Set<PsiElement> myUsedImports;
        private Set<PyImportedNameDefiner> myAllImports;
        private final ImmutableSet<String> myIgnoredIdentifiers;
        private volatile Boolean myIsEnabled;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, List<String> ignoredIdentifiers) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myUsedImports = Collections.synchronizedSet(new HashSet());
            this.myAllImports = Collections.synchronizedSet(new HashSet());
            this.myIsEnabled = null;
            this.myIgnoredIdentifiers = ImmutableSet.copyOf(ignoredIdentifiers);
        }

        public boolean isEnabled(@NotNull PsiElement anchor) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isEnabled"));
            }
            if (this.myIsEnabled == null) {
                boolean isPyCharm = PlatformUtils.isPyCharm();
                this.myIsEnabled = (isPyCharm && PythonSdkType.getSdk(anchor) != null || !isPyCharm) && !PySkeletonRefresher.isGeneratingSkeletons();
            }
            return this.myIsEnabled;
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.checkSlots(node);
        }

        private void checkSlots(PyQualifiedExpression node) {
            PyClass pyClass;
            PyType type;
            PyExpression qualifier = node.getQualifier();
            if (qualifier != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && (pyClass = ((PyClassType)type).getPyClass()).isNewStyleClass()) {
                if (pyClass.getOwnSlots() == null) {
                    return;
                }
                List<String> slots = pyClass.getSlots();
                String attrName = node.getReferencedName();
                if (slots != null && !slots.contains(attrName) && !slots.contains("__dict__")) {
                    ASTNode nameNode;
                    for (PyClass ancestor : pyClass.getAncestorClasses(this.myTypeEvalContext)) {
                        if (ancestor == null) {
                            return;
                        }
                        if ("object".equals(ancestor.getName())) break;
                        List<String> ancestorSlots = ancestor.getSlots();
                        if (ancestorSlots != null && !ancestorSlots.contains(attrName) && !ancestorSlots.contains("__dict__")) continue;
                        return;
                    }
                    PyQualifiedExpression e = (nameNode = node.getNameElement()) != null ? nameNode.getPsi() : node;
                    this.registerProblem((PsiElement)e, "'" + pyClass.getName() + "' object has no attribute '" + attrName + "'");
                }
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            super.visitPyImportElement(node);
            PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
            if (this.isEnabled(node) && (fromImport == null || !fromImport.isFromFuture())) {
                this.myAllImports.add(node);
            }
        }

        @Override
        public void visitPyStarImportElement(PyStarImportElement node) {
            super.visitPyStarImportElement(node);
            if (this.isEnabled(node)) {
                this.myAllImports.add(node);
            }
        }

        @Nullable
        private static PyExceptPart getImportErrorGuard(PyElement node) {
            PyTryExceptStatement tryExceptStatement;
            PyTryPart tryPart;
            PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class);
            if (importStatement != null && (tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class)) != null && (tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)tryPart, PyTryExceptStatement.class)) != null) {
                for (PyExceptPart exceptPart : tryExceptStatement.getExceptParts()) {
                    PyExpression expr = exceptPart.getExceptClass();
                    if (expr == null || !"ImportError".equals(expr.getName())) continue;
                    return exceptPart;
                }
            }
            return null;
        }

        private static boolean isGuardedByHasattr(@NotNull PyElement node, @NotNull String name) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isGuardedByHasattr"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isGuardedByHasattr"));
            }
            String nodeName = node.getName();
            if (nodeName != null) {
                ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner((PsiElement)node, nodeName);
                PyElement e = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PyConditionalStatementPart.class, PyConditionalExpression.class});
                while (e != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)e, (boolean)true)) {
                    ArrayList<PyCallExpression> calls = new ArrayList<PyCallExpression>();
                    PyExpression cond = null;
                    if (e instanceof PyConditionalStatementPart) {
                        cond = ((PyConditionalStatementPart)e).getCondition();
                    } else if (e instanceof PyConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)((PyConditionalExpression)e).getTruePart(), (PsiElement)node, (boolean)true)) {
                        cond = ((PyConditionalExpression)e).getCondition();
                    }
                    if (cond instanceof PyCallExpression) {
                        calls.add((PyCallExpression)cond);
                    }
                    if (cond != null) {
                        PyCallExpression[] callExpressions = (PyCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)cond, PyCallExpression.class);
                        if (callExpressions != null) {
                            calls.addAll(Arrays.asList(callExpressions));
                        }
                        for (PyCallExpression call : calls) {
                            PyExpression callee = call.getCallee();
                            PyExpression[] args = call.getArguments();
                            if (callee == null || !"hasattr".equals(callee.getName()) || args.length != 2 || !nodeName.equals(args[0].getName()) || !(args[1] instanceof PyStringLiteralExpression) || !((PyStringLiteralExpression)args[1]).getStringValue().equals(name)) continue;
                            return true;
                        }
                    }
                    e = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)e, PyConditionalStatementPart.class);
                }
            }
            return false;
        }

        @Override
        public void visitPyElement(PyElement node) {
            super.visitPyElement(node);
            PsiFile file = node.getContainingFile();
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)node.getProject());
            if (injectedLanguageManager.isInjectedFragment(file)) {
                PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost((PsiElement)node);
                this.processInjection(host);
            }
            if (node instanceof PyReferenceOwner) {
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                this.processReference(node, (PsiReference)((PyReferenceOwner)node).getReference(resolveContext));
            } else {
                if (node instanceof PsiLanguageInjectionHost) {
                    this.processInjection((PsiLanguageInjectionHost)node);
                }
                for (PsiReference reference : node.getReferences()) {
                    this.processReference(node, reference);
                }
            }
        }

        private void processInjection(@Nullable PsiLanguageInjectionHost node) {
            if (node == null) {
                return;
            }
            List files = InjectedLanguageManager.getInstance((Project)node.getProject()).getInjectedPsiFiles((PsiElement)node);
            if (files != null) {
                for (Pair pair : files) {
                    new PyRecursiveElementVisitor(){

                        @Override
                        public void visitPyElement(PyElement element) {
                            PyResolveContext resolveContext;
                            PsiPolyVariantReference reference;
                            super.visitPyElement(element);
                            if (element instanceof PyReferenceOwner && (reference = ((PyReferenceOwner)element).getReference(resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(Visitor.this.myTypeEvalContext))) != null) {
                                ResolveResult[] resolveResults;
                                for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                                    if (!(resolveResult instanceof ImportedResolveResult)) continue;
                                    Visitor.this.myUsedImports.addAll(((ImportedResolveResult)resolveResult).getNameDefiners());
                                }
                            }
                        }
                    }.visitElement((PsiElement)pair.getFirst());
                }
            }
        }

        private void processReference(PyElement node, @Nullable PsiReference reference) {
            boolean unresolved;
            if (!this.isEnabled((PsiElement)node) || reference == null || reference.isSoft()) {
                return;
            }
            HighlightSeverity severity = HighlightSeverity.ERROR;
            if (reference instanceof PsiReferenceEx && (severity = ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext)) == null) {
                return;
            }
            PyExceptPart guard = Visitor.getImportErrorGuard(node);
            if (guard != null) {
                this.processReferenceInImportGuard(node, guard);
                return;
            }
            if (node instanceof PyQualifiedExpression) {
                PyQualifiedExpression qExpr = (PyQualifiedExpression)node;
                PyExpression qualifier = qExpr.getQualifier();
                String name = node.getName();
                if (qualifier != null && name != null && Visitor.isGuardedByHasattr(qualifier, name)) {
                    return;
                }
            }
            PsiElement target = null;
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
                ResolveResult[] resolveResults = poly.multiResolve(false);
                unresolved = resolveResults.length == 0;
                for (ResolveResult resolveResult : resolveResults) {
                    if (target == null && resolveResult.isValidResult()) {
                        target = resolveResult.getElement();
                    }
                    if (!(resolveResult instanceof ImportedResolveResult)) continue;
                    this.myUsedImports.addAll(((ImportedResolveResult)resolveResult).getNameDefiners());
                }
            } else {
                target = reference.resolve();
                boolean bl = unresolved = target == null;
            }
            if (unresolved) {
                boolean ignoreUnresolved = false;
                for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                    if (!extension.ignoreUnresolvedReference(node, reference)) continue;
                    ignoreUnresolved = true;
                    break;
                }
                if (!ignoreUnresolved) {
                    this.registerUnresolvedReferenceProblem(node, reference, severity);
                }
                if (node.getParent() instanceof PyImportElement) {
                    this.myAllImports.remove(node.getParent());
                }
            } else if (reference instanceof PyImportReference && target == reference.getElement().getContainingFile() && !Visitor.isContainingFileImportAllowed(node, (PsiFile)target)) {
                this.registerProblem((PsiElement)node, "Import resolves to its containing file");
            }
        }

        private static boolean isContainingFileImportAllowed(PyElement node, PsiFile target) {
            return PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) == null && target.getName().equals("__init__.py");
        }

        private void processReferenceInImportGuard(PyElement node, PyExceptPart guard) {
            PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class);
            if (importElement != null) {
                String visibleName = importElement.getVisibleName();
                ScopeOwner owner = ScopeUtil.getScopeOwner(importElement);
                if (visibleName != null && owner != null) {
                    Collection<PsiElement> allWrites = ScopeUtil.getReadWriteElements(visibleName, owner, false, true);
                    ArrayList<PsiElement> writesInsideGuard = new ArrayList<PsiElement>();
                    for (PsiElement write : allWrites) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)write, (boolean)false)) continue;
                        writesInsideGuard.add(write);
                    }
                    if (writesInsideGuard.isEmpty()) {
                        PyTargetExpression asElement = importElement.getAsNameElement();
                        PyElement toHighlight = asElement != null ? asElement : node;
                        this.registerProblem((PsiElement)toHighlight, PyBundle.message("INSP.try.except.import.error", visibleName), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                    }
                }
            }
        }

        private void registerUnresolvedReferenceProblem(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull HighlightSeverity severity) {
            QualifiedName qname;
            List components;
            PyImportStatementBase importStatementBase;
            String refName;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "registerUnresolvedReferenceProblem"));
            }
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "registerUnresolvedReferenceProblem"));
            }
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "registerUnresolvedReferenceProblem"));
            }
            if (reference instanceof DocStringTypeReference) {
                return;
            }
            String description = null;
            PsiElement element = reference.getElement();
            String text = element.getText();
            TextRange rangeInElement = reference.getRangeInElement();
            String refText = text;
            if (rangeInElement.getStartOffset() > 0 && rangeInElement.getEndOffset() > 0) {
                refText = rangeInElement.substring(text);
            }
            ArrayList<LocalQuickFix> actions = new ArrayList<LocalQuickFix>(2);
            String string = refName = element instanceof PyQualifiedExpression ? ((PyQualifiedExpression)element).getReferencedName() : refText;
            if (refName == null || refName.length() <= 0) {
                return;
            }
            List<QualifiedName> qualifiedNames = Visitor.getCanonicalNames(reference, this.myTypeEvalContext);
            for (QualifiedName name : qualifiedNames) {
                String canonicalName = name.toString();
                for (String ignored : this.myIgnoredIdentifiers) {
                    String prefix;
                    if (!(ignored.endsWith(".*") ? canonicalName.startsWith(prefix = ignored.substring(0, ignored.length() - ".*".length())) : canonicalName.equals(ignored))) continue;
                    return;
                }
            }
            if (this.myIgnoredIdentifiers.contains((Object)refName)) {
                return;
            }
            if (element instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)element;
                if (PyNames.COMPARISON_OPERATORS.contains((Object)refName)) {
                    return;
                }
                if (expr.isQualified()) {
                    PyClassTypeImpl object_type = (PyClassTypeImpl)PyBuiltinCache.getInstance((PsiElement)node).getObjectType();
                    if (object_type != null && object_type.getPossibleInstanceMembers().contains(refName)) {
                        return;
                    }
                } else {
                    if (PyUnreachableCodeInspection.hasAnyInterruptedControlFlowPaths((PsiElement)expr)) {
                        return;
                    }
                    if (LanguageLevel.forElement((PsiElement)node).isOlderThan(LanguageLevel.PYTHON26) && "with".equals(refName)) {
                        actions.add(new UnresolvedRefAddFutureImportQuickFix());
                    }
                    if (refText.equals("true") || refText.equals("false")) {
                        actions.add(new UnresolvedRefTrueFalseQuickFix(element));
                    }
                    this.addAddSelfFix(node, expr, actions);
                    PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
                    if (!(callExpression == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
                        actions.add(new UnresolvedRefCreateFunctionQuickFix(callExpression, expr));
                    }
                    PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
                    PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
                    PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class);
                    if (parentFunction != null && decorator == null && importStatement == null) {
                        actions.add(new UnresolvedReferenceAddParameterQuickFix(refName));
                    }
                    actions.add(new PyRenameUnresolvedRefQuickFix());
                }
                if (PyModuleType.getPossibleInstanceMembers().contains(refName)) {
                    return;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class), (Class[])new Class[]{PyTryExceptStatement.class, PyIfStatement.class}) != null) {
                    severity = HighlightSeverity.WEAK_WARNING;
                    description = PyBundle.message("INSP.module.$0.not.found", refText);
                }
            }
            if (reference instanceof PsiReferenceEx && description == null) {
                description = ((PsiReferenceEx)reference).getUnresolvedDescription();
            }
            if (description == null) {
                boolean markedQualified = false;
                if (element instanceof PyQualifiedExpression) {
                    PyType type;
                    if ("__qualname__".equals(refText) && LanguageLevel.forElement(element).isAtLeast(LanguageLevel.PYTHON33)) {
                        return;
                    }
                    PyQualifiedExpression expr = (PyQualifiedExpression)element;
                    if (PyNames.COMPARISON_OPERATORS.contains((Object)expr.getReferencedName())) {
                        return;
                    }
                    PyExpression qualifier = expr.getQualifier();
                    if (qualifier != null && (type = this.myTypeEvalContext.getType(qualifier)) != null) {
                        if (this.ignoreUnresolvedMemberForType(type, reference, refName)) {
                            return;
                        }
                        this.addCreateMemberFromUsageFixes(type, reference, refText, actions);
                        if (type instanceof PyClassTypeImpl) {
                            description = reference instanceof PyOperatorReference ? PyBundle.message("INSP.unresolved.operator.ref", type.getName(), refName, ((PyOperatorReference)reference).getReadableOperatorName()) : PyBundle.message("INSP.unresolved.ref.$0.for.class.$1", refText, type.getName());
                            markedQualified = true;
                        } else {
                            if (Visitor.isHasCustomMember(refName, type)) {
                                return;
                            }
                            description = PyBundle.message("INSP.cannot.find.$0.in.$1", refText, type.getName());
                            markedQualified = true;
                        }
                    }
                }
                if (!markedQualified) {
                    description = PyBundle.message("INSP.unresolved.ref.$0", refText);
                    if (PythonReferenceImporter.isImportable(element)) {
                        Visitor.addAutoImportFix(node, reference, actions);
                    }
                    this.addCreateClassFix(refText, element, actions);
                }
            }
            ProblemHighlightType hl_type = severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            if (element != null && (importStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class)) != null && GenerateBinaryStubsFix.isApplicable(importStatementBase)) {
                actions.addAll(GenerateBinaryStubsFix.generateFixes(importStatementBase));
            }
            if (qualifiedNames.size() == 1) {
                QualifiedName qualifiedName = qualifiedNames.get(0);
                actions.add(new AddIgnoredIdentifierQuickFix(qualifiedName, false));
                if (qualifiedName.getComponentCount() > 1) {
                    actions.add(new AddIgnoredIdentifierQuickFix(qualifiedName.removeLastComponent(), true));
                }
            }
            Visitor.addPluginQuickFixes(reference, actions);
            if (reference instanceof PyImportReference && !(components = (qname = QualifiedName.fromDottedString((String)refName)).getComponents()).isEmpty()) {
                String packageName = (String)components.get(0);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                Sdk sdk = PythonSdkType.findPythonSdk(module);
                if (module != null && sdk != null && PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                    List<PyRequirement> requirements = Collections.singletonList(new PyRequirement(packageName));
                    String name = "Install package " + packageName;
                    actions.add(new PyPackageRequirementsInspection.PyInstallRequirementsFix(name, module, sdk, requirements));
                }
            }
            this.registerProblem((PsiElement)node, description, hl_type, null, rangeInElement, actions.toArray(new LocalQuickFix[actions.size()]));
        }

        private static boolean isHasCustomMember(@NotNull String refName, @NotNull PyType type) {
            if (refName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isHasCustomMember"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isHasCustomMember"));
            }
            return false;
        }

        @NotNull
        private static List<QualifiedName> getCanonicalNames(@NotNull PsiReference reference, @NotNull TypeEvalContext context) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "getCanonicalNames"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "getCanonicalNames"));
            }
            PsiElement element = reference.getElement();
            SmartList result = new SmartList();
            if (reference instanceof PyOperatorReference && element instanceof PyQualifiedExpression) {
                PyType type;
                PyExpression receiver = ((PyOperatorReference)reference).getReceiver();
                if (receiver != null && (type = context.getType(receiver)) instanceof PyClassType) {
                    String methodName = ((PyQualifiedExpression)element).getReferencedName();
                    ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(methodName, (PyClassType)type));
                }
            } else if (element instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)element;
                PyExpression qualifier = expr.getQualifier();
                String exprName = expr.getName();
                if (exprName != null) {
                    if (qualifier != null) {
                        PyType type = context.getType(qualifier);
                        if (type instanceof PyClassType) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(exprName, (PyClassType)type));
                        } else if (type instanceof PyModuleType) {
                            PyFile file = ((PyModuleType)type).getModule();
                            QualifiedName name = QualifiedNameFinder.findCanonicalImportPath(file, element);
                            if (name != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)name.append(exprName));
                            }
                        } else if (type instanceof PyUnionType) {
                            for (PyType memberType : ((PyUnionType)type).getMembers()) {
                                if (!(memberType instanceof PyClassType)) continue;
                                ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(exprName, (PyClassType)memberType));
                            }
                        }
                    } else {
                        PsiElement parent = element.getParent();
                        if (parent instanceof PyImportElement) {
                            QualifiedName path;
                            PsiElement resolved;
                            PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, PyImportStatementBase.class);
                            if (importStmt instanceof PyImportStatement) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromComponents((String[])new String[]{exprName}));
                            } else if (importStmt instanceof PyFromImportStatement && (resolved = ((PyFromImportStatement)importStmt).resolveImportSource()) != null && (path = QualifiedNameFinder.findCanonicalImportPath(resolved, element)) != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                            }
                        } else {
                            QualifiedName path = QualifiedNameFinder.findCanonicalImportPath(element, element);
                            if (path != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                            }
                        }
                    }
                }
            } else if (reference instanceof DocStringParameterReference) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromDottedString((String)reference.getCanonicalText()));
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "getCanonicalNames"));
            }
            return smartList;
        }

        private static QualifiedName extractAttributeQNameFromClassType(String exprName, PyClassType type) {
            String name = type.getClassQName();
            if (name != null) {
                return QualifiedName.fromDottedString((String)name).append(exprName);
            }
            return null;
        }

        private boolean ignoreUnresolvedMemberForType(@NotNull PyType type, PsiReference reference, String name) {
            Callable callable;
            PyImportedModule module;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "ignoreUnresolvedMemberForType"));
            }
            if (type instanceof PyNoneType || PyTypeChecker.isUnknown(type)) {
                return true;
            }
            if (type instanceof PyImportedModuleType && (module = ((PyImportedModuleType)type).getImportedModule()).resolve() == null) {
                return true;
            }
            if (type instanceof PyCustomType) {
                for (PyClassLikeType mimic : ((PyCustomType)type).getTypesToMimic()) {
                    if (!(mimic instanceof PyClassType) || !PyUtil.hasUnresolvedAncestors(((PyClassType)mimic).getPyClass(), this.myTypeEvalContext)) continue;
                    return true;
                }
            }
            if (type instanceof PyClassTypeImpl) {
                PyClass cls = ((PyClassType)type).getPyClass();
                if (Visitor.overridesGetAttr(cls, this.myTypeEvalContext)) {
                    return true;
                }
                if (cls.findProperty(name, true) != null) {
                    return true;
                }
                if (PyUtil.hasUnresolvedAncestors(cls, this.myTypeEvalContext)) {
                    return true;
                }
                if (this.isDecoratedAsDynamic(cls, true)) {
                    return true;
                }
                if (Visitor.hasUnresolvedDynamicMember((PyClassType)type, reference, name)) {
                    return true;
                }
            }
            if (type instanceof PyFunctionType && (callable = ((PyFunctionType)type).getCallable()) instanceof PyFunction && PyKnownDecoratorUtil.hasNonBuiltinDecorator((PyFunction)callable, this.myTypeEvalContext)) {
                return true;
            }
            for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                if (!extension.ignoreUnresolvedMember(type, name)) continue;
                return true;
            }
            return false;
        }

        private static boolean hasUnresolvedDynamicMember(@NotNull PyClassType type, PsiReference reference, @NotNull String name) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "hasUnresolvedDynamicMember"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "hasUnresolvedDynamicMember"));
            }
            for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
                Collection<PyCustomMember> resolveResult = provider.getMembers(type, reference.getElement());
                for (PyCustomMember member : resolveResult) {
                    if (!member.getName().equals(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isDecoratedAsDynamic(@NotNull PyClass cls, boolean inherited) {
            if (cls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "isDecoratedAsDynamic"));
            }
            if (inherited) {
                if (this.isDecoratedAsDynamic(cls, false)) {
                    return true;
                }
                for (PyClass base : cls.getAncestorClasses(this.myTypeEvalContext)) {
                    if (base == null || !this.isDecoratedAsDynamic(base, false)) continue;
                    return true;
                }
            } else {
                if (cls.getDecoratorList() != null) {
                    return true;
                }
                String docString = cls.getDocStringValue();
                if (docString != null && docString.contains("@DynamicAttrs")) {
                    return true;
                }
            }
            return false;
        }

        private void addCreateMemberFromUsageFixes(PyType type, PsiReference reference, String refText, List<LocalQuickFix> actions) {
            PsiElement element = reference.getElement();
            if (type instanceof PyClassTypeImpl) {
                PyClass cls = ((PyClassType)type).getPyClass();
                if (!PyBuiltinCache.getInstance(element).isBuiltin(cls)) {
                    if (element.getParent() instanceof PyCallExpression) {
                        actions.add(new AddMethodQuickFix(refText, cls.getName(), true));
                    } else if (!(reference instanceof PyOperatorReference)) {
                        actions.add(new AddFieldQuickFix(refText, "None", type.getName(), true));
                    }
                }
            } else if (type instanceof PyModuleType) {
                PyFile file = ((PyModuleType)type).getModule();
                actions.add(new AddFunctionQuickFix(refText, file.getName()));
                this.addCreateClassFix(refText, element, actions);
            }
        }

        private void addAddSelfFix(PyElement node, PyReferenceExpression expr, List<LocalQuickFix> actions) {
            PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
            if (containedClass != null && function != null) {
                PyParameter[] parameters = function.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return;
                }
                String qualifier = parameters[0].getText();
                PyDecoratorList decoratorList = function.getDecoratorList();
                boolean isClassMethod = false;
                if (decoratorList != null) {
                    for (PyElement pyElement : decoratorList.getDecorators()) {
                        PyExpression callee = pyElement.getCallee();
                        if (callee == null || !"classmethod".equals(callee.getText())) continue;
                        isClassMethod = true;
                    }
                }
                for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                    if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyElement pyElement : containedClass.getStatementList().getStatements()) {
                    PyType type;
                    PyExpression assignedValue;
                    PyExpression lhsExpression;
                    if (!(pyElement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)pyElement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)pyElement).getAssignedValue()) instanceof PyCallExpression) || (type = this.myTypeEvalContext.getType(assignedValue)) == null || !(type instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText("property")) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyElement pyElement : containedClass.getMethods(false)) {
                    if (!expr.getText().equals(pyElement.getName())) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
            }
        }

        private static void addAutoImportFix(PyElement node, PsiReference reference, List<LocalQuickFix> actions) {
            PsiFile file = InjectedLanguageManager.getInstance((Project)node.getProject()).getTopLevelFile((PsiElement)node);
            if (!(file instanceof PyFile)) {
                return;
            }
            AutoImportQuickFix importFix = PythonReferenceImporter.proposeImportFix(node, reference);
            if (importFix != null) {
                if (!Visitor.suppressHintForAutoImport(node, importFix) && PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
                    AutoImportHintAction autoImportHintAction = new AutoImportHintAction(importFix);
                    actions.add(autoImportHintAction);
                } else {
                    actions.add(importFix);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    actions.add(importFix.forLocalImport());
                }
            }
        }

        private static boolean suppressHintForAutoImport(PyElement node, AutoImportQuickFix importFix) {
            if (!Visitor.isCall(node) && importFix.hasOnlyFunctions()) {
                return true;
            }
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            return containingClass != null && (containingClass.findMethodByName(importFix.getNameToImport(), true) != null || containingClass.findInstanceAttribute(importFix.getNameToImport(), true) != null);
        }

        private void addCreateClassFix(String refText, PsiElement element, List<LocalQuickFix> actions) {
            if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !refText.toUpperCase().equals(refText) && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null) {
                PsiElement anchor = element;
                if (element instanceof PyQualifiedExpression) {
                    PyExpression expr = ((PyQualifiedExpression)element).getQualifier();
                    if (expr != null) {
                        PyType type = this.myTypeEvalContext.getType(expr);
                        anchor = type instanceof PyModuleType ? ((PyModuleType)type).getModule() : null;
                    }
                    if (anchor != null) {
                        actions.add(new CreateClassQuickFix(refText, anchor));
                    }
                }
            }
        }

        private static boolean isCall(PyElement node) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return callExpression != null && node == callExpression.getCallee();
        }

        @Nullable
        private static PsiElement resolveClassMember(@NotNull PyClass cls, @NotNull String name, @NotNull TypeEvalContext context) {
            PyResolveContext resolveContext;
            List<? extends RatedResolveResult> results;
            if (cls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "resolveClassMember"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "resolveClassMember"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "resolveClassMember"));
            }
            PyType type = context.getType(cls);
            if (type != null && (results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))) != null && !results.isEmpty()) {
                return results.get(0).getElement();
            }
            return null;
        }

        private static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
            if (cls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "overridesGetAttr"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor", "overridesGetAttr"));
            }
            PsiElement method = Visitor.resolveClassMember(cls, "__getattr__", context);
            if (method != null) {
                return true;
            }
            method = Visitor.resolveClassMember(cls, "__getattribute__", context);
            return method != null && !PyBuiltinCache.getInstance(cls).isBuiltin(method);
        }

        private static void addPluginQuickFixes(PsiReference reference, final List<LocalQuickFix> actions) {
            for (PyUnresolvedReferenceQuickFixProvider provider : (PyUnresolvedReferenceQuickFixProvider[])Extensions.getExtensions(PyUnresolvedReferenceQuickFixProvider.EP_NAME)) {
                provider.registerQuickFixes(reference, new Consumer<LocalQuickFix>(){

                    public void consume(LocalQuickFix localQuickFix) {
                        actions.add(localQuickFix);
                    }
                });
            }
        }

        public void highlightUnusedImports() {
            List<PsiElement> unused = this.collectUnusedImportElements();
            for (PsiElement element : unused) {
                if (element.getTextLength() <= 0) continue;
                this.registerProblem(element, "Unused import statement", ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, new OptimizeImportsQuickFix());
            }
        }

        private List<PsiElement> collectUnusedImportElements() {
            if (this.myAllImports.isEmpty()) {
                return Collections.emptyList();
            }
            NameDefiner first = this.myAllImports.iterator().next();
            if (first.getContainingFile() instanceof PyExpressionCodeFragment || PydevConsoleRunner.isInPydevConsole(first)) {
                return Collections.emptyList();
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            HashSet<PyImportedNameDefiner> unusedImports = new HashSet<PyImportedNameDefiner>(this.myAllImports);
            unusedImports.removeAll(this.myUsedImports);
            HashSet<PyImportedNameDefiner> unusedImportToSkip = new HashSet<PyImportedNameDefiner>();
            for (PyImportedNameDefiner unusedImport : unusedImports) {
                if (!PyUnresolvedReferencesInspection.importShouldBeSkippedByExtPoint(unusedImport)) continue;
                unusedImportToSkip.add(unusedImport);
            }
            unusedImports.removeAll(unusedImportToSkip);
            HashSet<String> usedImportNames = new HashSet<String>();
            for (PsiElement usedImport : this.myUsedImports) {
                if (!(usedImport instanceof NameDefiner)) continue;
                for (PyElement e : ((NameDefiner)usedImport).iterateNames()) {
                    usedImportNames.add(e.getName());
                }
            }
            HashSet<PyImportStatementBase> unusedStatements = new HashSet<PyImportStatementBase>();
            PyUnresolvedReferencesInspection suppressableInspection = new PyUnresolvedReferencesInspection();
            QualifiedName packageQName = null;
            List<String> dunderAll = null;
            for (PyImportedNameDefiner unusedImport : unusedImports) {
                QualifiedName importedQName;
                PsiElement importedElement;
                PyImportStatementBase importStatement;
                if (packageQName == null) {
                    PsiFile file = unusedImport.getContainingFile();
                    if (file instanceof PyFile) {
                        dunderAll = ((PyFile)file).getDunderAll();
                    }
                    if (file != null && PyUtil.isPackage(file)) {
                        packageQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
                    }
                }
                if ((importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyImportStatementBase.class)) == null || unusedStatements.contains(importStatement) || this.myUsedImports.contains(importStatement) || suppressableInspection.isSuppressedFor((PsiElement)importStatement) || PsiTreeUtil.getParentOfType((PsiElement)importStatement, PyTryExceptStatement.class) != null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyIfStatement.class) != null) {
                    boolean isUsed = false;
                    for (PyElement e : unusedImport.iterateNames()) {
                        if (!usedImportNames.contains(e.getName())) continue;
                        isUsed = true;
                    }
                    if (isUsed) continue;
                }
                if (unusedImport instanceof PyImportElement) {
                    PyImportElement importElement = (PyImportElement)unusedImport;
                    PsiElement element = importElement.resolve();
                    if (element == null) {
                        if (importElement.getImportedQName() == null) continue;
                        if (Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                            result.add((PsiElement)importStatement);
                            continue;
                        }
                        result.add(importElement);
                        continue;
                    }
                    if (dunderAll != null && dunderAll.contains(importElement.getVisibleName())) continue;
                    importedElement = element.getContainingFile();
                } else {
                    assert (importStatement instanceof PyFromImportStatement);
                    importedElement = ((PyFromImportStatement)importStatement).resolveImportSource();
                    if (importedElement == null) continue;
                }
                if (packageQName != null && importedElement instanceof PsiFileSystemItem && (importedQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)importedElement)) != null && importedQName.matchesPrefix(packageQName)) continue;
                if (unusedImport instanceof PyStarImportElement || Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                    unusedStatements.add(importStatement);
                    result.add((PsiElement)importStatement);
                    continue;
                }
                result.add(unusedImport);
            }
            return result;
        }

        private static boolean areAllImportsUnused(PyImportStatementBase importStatement, Set<PyImportedNameDefiner> unusedImports) {
            PyImportElement[] elements;
            for (PyImportElement element : elements = importStatement.getImportElements()) {
                if (unusedImports.contains(element)) continue;
                return false;
            }
            return true;
        }

        public void optimizeImports() {
            List<PsiElement> elementsToDelete = this.collectUnusedImportElements();
            for (PsiElement element : elementsToDelete) {
                if (!element.isValid()) continue;
                element.delete();
            }
        }
    }
}

