/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class UnresolvedReferenceAddSelfQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private PyReferenceExpression myElement;
    private String myQualifier;

    public UnresolvedReferenceAddSelfQuickFix(@NotNull PyReferenceExpression element, @NotNull String qualifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "<init>"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "<init>"));
        }
        this.myElement = element;
        this.myQualifier = qualifier;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.unresolved.reference", this.myElement.getText(), this.myQualifier);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Add qualifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "getFamilyName"));
        }
        return "Add qualifier";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddSelfQuickFix", "applyFix"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myElement)) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myElement), this.myQualifier + "." + this.myElement.getText());
        this.myElement.replace((PsiElement)expression);
    }
}

