/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import org.jetbrains.annotations.NotNull;

public class UnresolvedReferenceAddParameterQuickFix
implements LocalQuickFix {
    private String myName;

    public UnresolvedReferenceAddParameterQuickFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.unresolved.reference.add.param.$0", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddParameterQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.unresolved.reference.add.param", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddParameterQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddParameterQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/UnresolvedReferenceAddParameterQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyNamedParameter parameter = elementGenerator.createParameter(element.getText() + "=None");
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null) {
            PyParameterList parameterList = function.getParameterList();
            parameterList.addParameter(parameter);
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(parameterList);
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parameter);
            builder.replaceRange(TextRange.create((int)(parameter.getTextLength() - 4), (int)parameter.getTextLength()), "None");
            builder.run();
        }
    }
}

