/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import org.jetbrains.annotations.NotNull;

public class UnresolvedRefCreateFunctionQuickFix
implements LocalQuickFix {
    private PyCallExpression myElement;
    private PyReferenceExpression myReference;

    public UnresolvedRefCreateFunctionQuickFix(PyCallExpression element, PyReferenceExpression reference) {
        this.myElement = element;
        this.myReference = reference;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.unresolved.reference.create.function.$0", this.myReference.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix", "applyFix"));
        }
        if (!this.myElement.isValid() || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myElement)) {
            return;
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder(this.myReference.getText());
        PyArgumentList argumentList = this.myElement.getArgumentList();
        if (argumentList != null && !PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)this.myReference, (boolean)false)) {
            for (PyExpression param : argumentList.getArguments()) {
                if (param instanceof PyKeywordArgument) {
                    functionBuilder.parameter(((PyKeywordArgument)param).getKeyword());
                    continue;
                }
                if (param instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)param;
                    functionBuilder.parameter(refex.getReferencedName());
                    continue;
                }
                functionBuilder.parameter("param");
            }
        } else {
            functionBuilder.parameter("args");
        }
        PyFunction function = functionBuilder.buildFunction(project, LanguageLevel.getDefault());
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, PyFunction.class);
        if (parentFunction != null) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)parentFunction, PyClass.class);
            if (parentClass != null) {
                parent = parentClass.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentClass);
            } else {
                parent = parentFunction.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentFunction);
            }
        } else {
            PyStatement statement = (PyStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, PyStatement.class);
            if (statement != null && (parent = statement.getParent()) != null) {
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)statement);
            }
        }
        function = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)function);
        ParamHelper.walkDownParamArray(function.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)function.getStatementList(), "pass");
        builder.run();
    }
}

