/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NotNull;

public class TransformClassicClassQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.classic.class.transform", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class)) != null) {
            PyClass pyClass = (PyClass)psiElement;
            PyExpression[] superClassExpressions = pyClass.getSuperClassExpressions();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            if (superClassExpressions.length == 0) {
                pyClass.replace(generator.createFromText(LanguageLevel.getDefault(), PyClass.class, "class " + pyClass.getName() + "(" + "object" + "):\n    " + pyClass.getStatementList().getText()));
            } else {
                StringBuilder stringBuilder = new StringBuilder("class ");
                stringBuilder.append(pyClass.getName()).append("(");
                for (PyExpression expression : superClassExpressions) {
                    stringBuilder.append(expression.getText()).append(", ");
                }
                stringBuilder.append("object").append(":\n    ");
                stringBuilder.append(pyClass.getStatementList().getText());
                pyClass.replace(generator.createFromText(LanguageLevel.getDefault(), PyClass.class, stringBuilder.toString()));
            }
        }
    }
}

