/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatementEffectIntroduceVariableQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.introduce.variable", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/StatementEffectIntroduceVariableQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/StatementEffectIntroduceVariableQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/StatementEffectIntroduceVariableQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/StatementEffectIntroduceVariableQuickFix", "applyFix"));
        }
        PsiElement expression = descriptor.getPsiElement();
        if (expression != null && expression.isValid()) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            PyAssignmentStatement assignment = elementGenerator.createFromText(LanguageLevel.forElement(expression), PyAssignmentStatement.class, "var = " + expression.getText());
            if ((expression = expression.replace((PsiElement)assignment)) == null) {
                return;
            }
            expression = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(expression);
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(expression);
            PyExpression leftHandSideExpression = ((PyAssignmentStatement)expression).getLeftHandSideExpression();
            assert (leftHandSideExpression != null);
            builder.replaceElement((PsiElement)leftHandSideExpression, "var");
            builder.run();
        }
    }
}

