/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementEffectFunctionCallQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.statement.effect", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "applyFix"));
        }
        PsiElement expression = descriptor.getPsiElement();
        if (expression != null && expression.isWritable() && expression instanceof PyReferenceExpression) {
            String expressionText = expression.getText();
            if ("print".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replacePrint(expression);
            } else if ("exec".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replaceExec(expression);
            } else {
                expression.replace((PsiElement)PyElementGenerator.getInstance(project).createCallExpression(LanguageLevel.forElement(expression), expressionText));
            }
        }
    }

    private static void replaceExec(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "replaceExec"));
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        if (next == null) {
            stringBuilder.append(")");
            expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyExpression.class, stringBuilder.toString()));
            return;
        }
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next instanceof PyExpressionStatement) {
            PyExpression expr = ((PyExpressionStatement)next).getExpression();
            if (expr instanceof PyBinaryExpression) {
                PsiElement operator = ((PyBinaryExpression)expr).getPsiOperator();
                if (operator instanceof LeafPsiElement && ((LeafPsiElement)operator).getElementType() == PyTokenTypes.IN_KEYWORD) {
                    StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)expr);
                } else {
                    stringBuilder.append(next.getText());
                }
            } else if (expr instanceof PyTupleExpression) {
                PyExpression[] elements = ((PyTupleExpression)expr).getElements();
                if (elements.length > 1) {
                    if (elements[0] instanceof PyBinaryExpression) {
                        StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)elements[0]);
                    }
                    stringBuilder.append(", ");
                    stringBuilder.append(elements[1].getText());
                }
            } else {
                stringBuilder.append(((PyExpressionStatement)next).getExpression().getText());
            }
        } else {
            stringBuilder.append(next.getText());
        }
        next.delete();
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyExpression.class, stringBuilder.toString()));
    }

    private static String getComment(@Nullable PsiElement next) {
        PsiElement lastChild;
        String commentText = null;
        if (next != null && (lastChild = next.getLastChild()) instanceof PsiComment) {
            commentText = lastChild.getText();
        }
        return commentText;
    }

    private static void addInArguments(@NotNull StringBuilder stringBuilder, @NotNull PyBinaryExpression binaryExpression) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "addInArguments"));
        }
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "addInArguments"));
        }
        stringBuilder.append(binaryExpression.getLeftExpression().getText());
        stringBuilder.append(", ");
        PyExpression rightExpression = binaryExpression.getRightExpression();
        if (rightExpression != null) {
            stringBuilder.append(rightExpression.getText());
        }
    }

    private static void replacePrint(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "replacePrint"));
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next != null) {
            String text = next instanceof PyExpressionStatement ? ((PyExpressionStatement)next).getExpression().getText() : next.getText();
            stringBuilder.append(text);
            if (text.endsWith(",")) {
                stringBuilder.append(" end=' '");
            }
            next.delete();
        }
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyExpression.class, stringBuilder.toString()));
    }

    private static PsiElement getNextElement(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix", "getNextElement"));
        }
        PsiElement whiteSpace = expression.getContainingFile().findElementAt(expression.getTextOffset() + expression.getTextLength());
        PsiElement next = null;
        if (whiteSpace instanceof PsiWhiteSpace) {
            String whiteSpaceText = whiteSpace.getText();
            if (!whiteSpaceText.contains("\n")) {
                next = whiteSpace.getNextSibling();
                while (next instanceof PsiWhiteSpace && whiteSpaceText.contains("\\")) {
                    next = next.getNextSibling();
                }
            }
        } else {
            next = whiteSpace;
        }
        RemoveUnnecessaryBackslashQuickFix.removeBackSlash(next);
        if (whiteSpace != null) {
            whiteSpace.delete();
        }
        return next;
    }
}

