/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanCheckQuickFix
implements LocalQuickFix {
    private String myReplacementText;

    public SimplifyBooleanCheckQuickFix(PyBinaryExpression binaryExpression) {
        this.myReplacementText = SimplifyBooleanCheckQuickFix.createReplacementText(binaryExpression);
    }

    private static boolean isTrue(PyExpression expression) {
        return "True".equals(expression.getText());
    }

    private static boolean isFalse(PyExpression expression) {
        return "False".equals(expression.getText());
    }

    private static boolean isNull(PyExpression expression) {
        return "0".equals(expression.getText());
    }

    private static boolean isEmpty(PyExpression expression) {
        return "[]".equals(expression.getText());
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.simplify.$0", this.myReplacementText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Simplify boolean expression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix", "getFamilyName"));
        }
        return "Simplify boolean expression";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/SimplifyBooleanCheckQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!element.isValid() || !(element instanceof PyBinaryExpression)) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement(element), this.myReplacementText));
    }

    private static String createReplacementText(PyBinaryExpression expression) {
        PyExpression leftExpression = expression.getLeftExpression();
        PyExpression rightExpression = expression.getRightExpression();
        boolean positiveCondition = !TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.NE, PyTokenTypes.NE_OLD}).contains((IElementType)expression.getOperator());
        PyExpression resultExpression = SimplifyBooleanCheckQuickFix.isTrue(leftExpression) || SimplifyBooleanCheckQuickFix.isFalse(leftExpression) || SimplifyBooleanCheckQuickFix.isNull(leftExpression) || SimplifyBooleanCheckQuickFix.isEmpty(leftExpression) ? rightExpression : leftExpression;
        return ((positiveCondition ^= SimplifyBooleanCheckQuickFix.isFalse(leftExpression) || SimplifyBooleanCheckQuickFix.isFalse(rightExpression) || SimplifyBooleanCheckQuickFix.isNull(rightExpression) || SimplifyBooleanCheckQuickFix.isNull(leftExpression) || SimplifyBooleanCheckQuickFix.isEmpty(rightExpression) || SimplifyBooleanCheckQuickFix.isEmpty(leftExpression)) ? "" : "not ") + resultExpression.getText();
    }
}

