/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyNamedParameter;
import org.jetbrains.annotations.NotNull;

public class RenameParameterQuickFix
implements LocalQuickFix {
    private final String myNewName;

    public RenameParameterQuickFix(String newName) {
        this.myNewName = newName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/RenameParameterQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/RenameParameterQuickFix", "applyFix"));
        }
        PsiElement elt = descriptor.getPsiElement();
        if (elt != null && elt instanceof PyNamedParameter && elt.isWritable()) {
            new RenameProcessor(project, elt, this.myNewName, false, true).run();
        }
    }

    @NotNull
    public String getFamilyName() {
        if ("Rename parameter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RenameParameterQuickFix", "getFamilyName"));
        }
        return "Rename parameter";
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.rename.parameter.to.$0", this.myNewName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RenameParameterQuickFix", "getName"));
        }
        return string;
    }
}

