/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import org.jetbrains.annotations.NotNull;

public class RemoveUnnecessaryBackslashQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.remove.unnecessary.backslash", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement != null) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)problemElement, (Class[])PythonEnterHandler.IMPLICIT_WRAP_CLASSES);
            RemoveUnnecessaryBackslashQuickFix.removeBackSlash(parent);
        }
    }

    public static void removeBackSlash(PsiElement parent) {
        if (parent != null) {
            Stack stack = new Stack();
            if (parent instanceof PyParenthesizedExpression) {
                stack.push((Object)((PyParenthesizedExpression)parent).getContainedExpression());
            } else {
                stack.push((Object)parent);
            }
            while (!stack.isEmpty()) {
                PsiElement el = (PsiElement)stack.pop();
                PsiWhiteSpace[] children = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)el, PsiWhiteSpace.class);
                if (children != null) {
                    for (PsiWhiteSpace psiWhiteSpace : children) {
                        if (!psiWhiteSpace.getText().contains("\\")) continue;
                        psiWhiteSpace.delete();
                    }
                }
                for (PsiWhiteSpace psiWhiteSpace : el.getChildren()) {
                    stack.push((Object)psiWhiteSpace);
                }
            }
        }
    }
}

