/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class RemovePrefixQuickFix
implements LocalQuickFix {
    private final String myPrefix;

    public RemovePrefixQuickFix(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("INTN.remove.leading.$0", this.myPrefix);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.remove.leading.prefix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix", "applyFix"));
        }
        PsiElement stringLiteralExpression = descriptor.getPsiElement();
        if (stringLiteralExpression instanceof PyStringLiteralExpression) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            int length = PyStringLiteralExpressionImpl.getPrefixLength(stringLiteralExpression.getText());
            stringLiteralExpression.replace((PsiElement)elementGenerator.createExpressionFromText(stringLiteralExpression.getText().substring(length)));
        }
    }
}

