/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RemoveArgumentEqualDefaultQuickFix
implements LocalQuickFix {
    Set<PyExpression> myProblemElements;

    public RemoveArgumentEqualDefaultQuickFix(Set<PyExpression> problemElements) {
        this.myProblemElements = problemElements;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.remove.argument.equal.default", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyArgumentList argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
        if (argumentList == null) {
            return;
        }
        StringBuilder newArgumentList = new StringBuilder("foo(");
        PyExpression[] arguments = argumentList.getArguments();
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i != arguments.length; ++i) {
            if (this.myProblemElements.contains(arguments[i])) continue;
            newArgs.add(arguments[i].getText());
        }
        newArgumentList.append(StringUtil.join(newArgs, (String)", ")).append(")");
        PyExpression expression = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement((PsiElement)argumentList), PyExpressionStatement.class, newArgumentList.toString()).getExpression();
        if (expression instanceof PyCallExpression) {
            argumentList.replace((PsiElement)((PyCallExpression)expression).getArgumentList());
        }
    }
}

