/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import org.jetbrains.annotations.NotNull;

public class RedundantParenthesesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.redundant.parentheses", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/RedundantParenthesesQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyExpression binaryExpression = ((PyParenthesizedExpression)element).getContainedExpression();
        PyBinaryExpression parent = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class);
        if (binaryExpression instanceof PyBinaryExpression && parent != null) {
            if (!RedundantParenthesesQuickFix.replaceBinaryExpression((PyBinaryExpression)binaryExpression)) {
                element.replace((PsiElement)binaryExpression);
            }
        } else {
            while (element instanceof PyParenthesizedExpression) {
                PyExpression expression = ((PyParenthesizedExpression)element).getContainedExpression();
                if (expression == null) continue;
                element = element.replace((PsiElement)expression);
            }
        }
    }

    private static boolean replaceBinaryExpression(PyBinaryExpression element) {
        PyExpression left = element.getLeftExpression();
        PyExpression right = element.getRightExpression();
        if (left instanceof PyParenthesizedExpression && right instanceof PyParenthesizedExpression) {
            PyExpression leftContained = ((PyParenthesizedExpression)left).getContainedExpression();
            PyExpression rightContained = ((PyParenthesizedExpression)right).getContainedExpression();
            if (leftContained != null && rightContained != null) {
                left.replace((PsiElement)leftContained);
                right.replace((PsiElement)rightContained);
                return true;
            }
        }
        return false;
    }
}

