/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import org.jetbrains.annotations.NotNull;

public class PyUpdatePropertySignatureQuickFix
implements LocalQuickFix {
    private final boolean myHasValue;

    public PyUpdatePropertySignatureQuickFix(boolean hasValue) {
        this.myHasValue = hasValue;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.update.parameters", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyUpdatePropertySignatureQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        Callable function = (Callable)PsiTreeUtil.getParentOfType((PsiElement)element, Callable.class, (boolean)false);
        assert (function != null);
        PyParameterList parameterList = function.getParameterList();
        PyParameter[] parameters = parameterList.getParameters();
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        String selfText = parameters.length != 0 ? parameters[0].getText() : "self";
        StringBuilder functionText = new StringBuilder("def foo(" + selfText);
        if (this.myHasValue) {
            String valueText = parameters.length > 1 ? parameters[1].getText() : "value";
            functionText.append(", ").append(valueText);
        }
        functionText.append("): pass");
        PyParameterList list = generator.createFromText(LanguageLevel.forElement(element), PyFunction.class, functionText.toString()).getParameterList();
        parameterList.replace((PsiElement)list);
    }
}

