/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import org.jetbrains.annotations.NotNull;

public class PyReplaceTupleWithListQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.make.list", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PySubscriptionExpression subscriptionExpression;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PyAssignmentStatement);
        PyExpression[] targets = ((PyAssignmentStatement)element).getTargets();
        if (targets.length == 1 && targets[0] instanceof PySubscriptionExpression && (subscriptionExpression = (PySubscriptionExpression)targets[0]).getOperand() instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)subscriptionExpression.getOperand();
            element = referenceExpression.followAssignmentsChain(PyResolveContext.defaultContext()).getElement();
            if (element instanceof PyParenthesizedExpression) {
                PyExpression expression = ((PyParenthesizedExpression)element).getContainedExpression();
                PyReplaceTupleWithListQuickFix.replaceWithListLiteral(element, (PyTupleExpression)expression);
            } else if (element instanceof PyTupleExpression) {
                PyReplaceTupleWithListQuickFix.replaceWithListLiteral(element, (PyTupleExpression)element);
            }
        }
    }

    private static void replaceWithListLiteral(PsiElement element, PyTupleExpression expression) {
        String expressionText = expression.getElements().length == 0 ? "" : expression.getText();
        PyExpression literal = PyElementGenerator.getInstance(element.getProject()).createExpressionFromText(LanguageLevel.forElement(element), "[" + expressionText + "]");
        element.replace((PsiElement)literal);
    }
}

