/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRenameElementQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        if ("Rename element" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "getName"));
        }
        return "Rename element";
    }

    @NotNull
    public String getFamilyName() {
        if ("Rename element" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "getFamilyName"));
        }
        return "Rename element";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        VirtualFile virtualFile;
        PsiNameIdentifierOwner nameOwner;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyReferenceExpression) {
            PsiReference reference = element.getReference();
            if (reference == null) {
                return;
            }
            element = reference.resolve();
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = nameOwner = element instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)element : (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNameIdentifierOwner.class, (boolean)true);
        if (nameOwner != null && (virtualFile = nameOwner.getContainingFile().getVirtualFile()) != null) {
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PyRenameElementQuickFix.renameInUnitTestMode(project, nameOwner, editor);
            } else if (this.checkLocalScope(element) != null && (nameOwner instanceof PyNamedParameter || nameOwner instanceof PyTargetExpression)) {
                new VariableInplaceRenamer((PsiNamedElement)nameOwner, editor).performInplaceRename();
            } else {
                PsiElementRenameHandler.invoke((PsiElement)nameOwner, project, (PsiElement)ScopeUtil.getScopeOwner((PsiElement)nameOwner), editor);
            }
        }
    }

    @Nullable
    protected PsiElement checkLocalScope(PsiElement element) {
        SearchScope searchScope = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).getUseScope(element);
        if (searchScope instanceof LocalSearchScope) {
            PsiElement[] elements = ((LocalSearchScope)searchScope).getScope();
            return PsiTreeUtil.findCommonParent((PsiElement[])elements);
        }
        return null;
    }

    private static void renameInUnitTestMode(@NotNull Project project, @NotNull PsiNameIdentifierOwner nameOwner, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "renameInUnitTestMode"));
        }
        if (nameOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameOwner", "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix", "renameInUnitTestMode"));
        }
        PsiElement substitution = RenamePsiElementProcessor.forElement((PsiElement)nameOwner).substituteElementToRename((PsiElement)nameOwner, editor);
        if (substitution != null) {
            new RenameProcessor(project, substitution, "a", false, false).run();
        }
    }
}

