/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import org.jetbrains.annotations.NotNull;

public class PyRemoveStatementQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.remove.statement", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveStatementQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveStatementQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyRemoveStatementQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyRemoveStatementQuickFix", "applyFix"));
        }
        PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PyStatement.class, (boolean)false);
        if (statement != null) {
            PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statement, PyStatementList.class);
            if (statementList != null && statementList.getStatements().length == 1) {
                PyPassStatement passStatement = PyElementGenerator.getInstance(project).createPassStatement();
                statementList.addBefore((PsiElement)passStatement, (PsiElement)statement);
            }
            statement.delete();
        }
    }
}

