/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.editor.PythonDocCommentUtil;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyRemoveParameterQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.remove.parameter", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PyParameter);
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (pyFunction != null) {
            List<UsageInfo> usages = PyRefactoringUtil.findUsages(pyFunction, false);
            for (UsageInfo usage : usages) {
                PyArgumentList argumentList;
                PsiElement callExpression;
                PsiElement usageElement = usage.getElement();
                if (usageElement == null || !((callExpression = usageElement.getParent()) instanceof PyCallExpression) || (argumentList = ((PyCallExpression)callExpression).getArgumentList()) == null) continue;
                CallArgumentsMapping mapping = argumentList.analyzeCall(PyResolveContext.noImplicits());
                for (Map.Entry<PyExpression, PyNamedParameter> parameterEntry : mapping.getPlainMappedParams().entrySet()) {
                    if (!parameterEntry.getValue().equals(element)) continue;
                    parameterEntry.getKey().delete();
                }
            }
            PyStringLiteralExpression expression = pyFunction.getDocStringExpression();
            String paramName = ((PyParameter)element).getName();
            if (expression != null && paramName != null) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)pyFunction);
                assert (module != null);
                PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
                String prefix = documentationSettings.isEpydocFormat(pyFunction.getContainingFile()) ? "@" : ":";
                String replacement = PythonDocCommentUtil.removeParamFromDocstring(expression.getText(), prefix, paramName);
                PyExpression str = PyElementGenerator.getInstance(project).createDocstring(replacement).getExpression();
                expression.replace((PsiElement)str);
            }
        }
        PsiElement nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        element.delete();
        if (nextSibling != null && nextSibling.getNode().getElementType().equals((Object)PyTokenTypes.COMMA)) {
            nextSibling.delete();
            return;
        }
        if (prevSibling != null && prevSibling.getNode().getElementType().equals((Object)PyTokenTypes.COMMA)) {
            prevSibling.delete();
        }
    }
}

