/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyRemoveArgumentQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.remove.argument", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveArgumentQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyRemoveArgumentQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyRemoveArgumentQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyRemoveArgumentQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PyExpression)) {
            return;
        }
        PyExpression expression = (PyExpression)element;
        PsiElement nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)expression, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)expression, (Class[])new Class[]{PsiWhiteSpace.class});
        expression.delete();
        if (nextSibling != null && nextSibling.getNode().getElementType().equals((Object)PyTokenTypes.COMMA)) {
            nextSibling.delete();
            return;
        }
        if (prevSibling != null && prevSibling.getNode().getElementType().equals((Object)PyTokenTypes.COMMA)) {
            prevSibling.delete();
        }
    }
}

