/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyMoveExceptQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.move.except.up", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMoveExceptQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMoveExceptQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyMoveExceptQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyMoveExceptQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyExceptPart part = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)element, PyExceptPart.class);
        if (part == null) {
            return;
        }
        PyExpression exceptClassExpression = part.getExceptClass();
        if (exceptClassExpression == null) {
            return;
        }
        PsiElement exceptClass = ((PyReferenceExpression)exceptClassExpression).followAssignmentsChain(PyResolveContext.noImplicits()).getElement();
        if (exceptClass instanceof PyClass) {
            PyTryExceptStatement statement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)part, PyTryExceptStatement.class);
            if (statement == null) {
                return;
            }
            PyExceptPart prevExceptPart = (PyExceptPart)PsiTreeUtil.getPrevSiblingOfType((PsiElement)part, PyExceptPart.class);
            ArrayList superClasses = Lists.newArrayList((Object[])((PyClass)exceptClass).getSuperClasses());
            while (prevExceptPart != null) {
                PyExpression classExpression = prevExceptPart.getExceptClass();
                if (classExpression == null) {
                    return;
                }
                PsiElement aClass = ((PyReferenceExpression)classExpression).followAssignmentsChain(PyResolveContext.noImplicits()).getElement();
                if (aClass instanceof PyClass && superClasses.contains(aClass)) {
                    statement.addBefore(part, prevExceptPart);
                    part.delete();
                    return;
                }
                prevExceptPart = (PyExceptPart)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevExceptPart, PyExceptPart.class);
            }
        }
    }
}

