/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyMoveAttributeToInitQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.move.attribute", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMoveAttributeToInitQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMoveAttributeToInitQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyMoveAttributeToInitQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyMoveAttributeToInitQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PyTargetExpression)) {
            return;
        }
        PyTargetExpression targetExpression = (PyTargetExpression)element;
        PyClass containingClass = targetExpression.getContainingClass();
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
        if (containingClass == null || assignment == null) {
            return;
        }
        Function callback = FunctionUtil.constant((Object)assignment);
        AddFieldQuickFix.addFieldToInit(project, containingClass, ((PyTargetExpression)element).getName(), (Function<String, PyStatement>)callback);
        PyMoveAttributeToInitQuickFix.removeDefinition(assignment);
    }

    private static boolean removeDefinition(PyAssignmentStatement assignment) {
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)assignment, PyStatementList.class);
        if (statementList == null) {
            return false;
        }
        if (statementList.getStatements().length == 1) {
            PyPassStatement passStatement = PyElementGenerator.getInstance(assignment.getProject()).createPassStatement();
            statementList.addBefore((PsiElement)passStatement, assignment);
        }
        assignment.delete();
        return true;
    }
}

