/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyMakeMethodStaticQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.make.static", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyFunction problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (problemFunction == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyUtil.deleteParameter(problemFunction, 0);
        PyDecoratorList problemDecoratorList = problemFunction.getDecoratorList();
        ArrayList<String> decoTexts = new ArrayList<String>();
        decoTexts.add("@staticmethod");
        if (problemDecoratorList != null) {
            PyDecorator[] decorators;
            for (PyDecorator deco : decorators = problemDecoratorList.getDecorators()) {
                decoTexts.add(deco.getText());
            }
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyDecoratorList decoratorList = generator.createDecoratorList(decoTexts.toArray(new String[decoTexts.size()]));
        if (problemDecoratorList != null) {
            problemDecoratorList.replace((PsiElement)decoratorList);
        } else {
            problemFunction.addBefore((PsiElement)decoratorList, problemFunction.getFirstChild());
        }
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            PyMakeMethodStaticQuickFix.updateUsage((PyReferenceExpression)usageElement);
        }
    }

    private static void updateUsage(@NotNull PyReferenceExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "updateUsage"));
        }
        PyExpression qualifier = element.getQualifier();
        if (qualifier == null) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference == null) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PyClass) {
            PyMakeMethodStaticQuickFix.updateArgumentList(element);
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix", "updateArgumentList"));
        }
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            PyExpression argument = arguments[0];
            PyUtil.eraseWhitespaceAndComma(argument.getParent().getNode(), (PsiElement)argument, false);
            argument.delete();
        }
    }
}

