/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyMakeFunctionFromMethodQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.make.function", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyFunction problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (problemFunction == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyUtil.deleteParameter(problemFunction, 0);
        PsiElement copy = problemFunction.copy();
        PyStatementList classStatementList = containingClass.getStatementList();
        classStatementList.deleteChildRange(problemFunction, problemFunction);
        if (classStatementList.getStatements().length < 1) {
            classStatementList.add((PsiElement)PyElementGenerator.getInstance(project).createPassStatement());
        }
        PsiFile file = containingClass.getContainingFile();
        PyClass aClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)containingClass, PyClass.class);
        if (aClass == null) {
            aClass = containingClass;
        }
        copy = file.addBefore(copy, (PsiElement)aClass);
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            PsiFile usageFile = usageElement.getContainingFile();
            PyMakeFunctionFromMethodQuickFix.updateUsage(copy, (PyReferenceExpression)usageElement, usageFile, !usageFile.equals(file));
        }
    }

    private static void updateUsage(@NotNull PsiElement finalElement, @NotNull PyReferenceExpression element, @NotNull PsiFile usageFile, boolean addImport) {
        if (finalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalElement", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "updateUsage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "updateUsage"));
        }
        if (usageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageFile", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "updateUsage"));
        }
        PyExpression qualifier = element.getQualifier();
        if (qualifier == null) {
            return;
        }
        if (qualifier.getText().equals("self")) {
            PyUtil.removeQualifier(element);
        }
        if (qualifier instanceof PyCallExpression) {
            if (addImport) {
                AddImportHelper.addImport((PsiNamedElement)finalElement, usageFile, element);
            }
            PyUtil.removeQualifier(element);
            PyMakeFunctionFromMethodQuickFix.removeFormerImport(usageFile, addImport);
        } else {
            PsiReference reference = qualifier.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression) {
                PyMakeFunctionFromMethodQuickFix.updateAssignment(element, resolved);
            } else if (resolved instanceof PyClass) {
                PsiElement dot = qualifier.getNextSibling();
                if (dot != null) {
                    dot.delete();
                }
                qualifier.delete();
                PyMakeFunctionFromMethodQuickFix.updateArgumentList(element);
            }
        }
    }

    private static void removeFormerImport(@NotNull PsiFile usageFile, boolean addImport) {
        if (usageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageFile", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "removeFormerImport"));
        }
        if (usageFile instanceof PyFile && addImport) {
            LocalInspectionToolSession session = new LocalInspectionToolSession(usageFile, 0, usageFile.getTextLength());
            final PyUnresolvedReferencesInspection.Visitor visitor = new PyUnresolvedReferencesInspection.Visitor(null, session, Collections.<String>emptyList());
            usageFile.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                @Override
                public void visitPyElement(PyElement node) {
                    super.visitPyElement(node);
                    node.accept(visitor);
                }
            });
            visitor.optimizeImports();
        }
    }

    private static void updateAssignment(PyReferenceExpression element, @NotNull PsiElement resolved) {
        PyExpression callee;
        PyExpression value;
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "updateAssignment"));
        }
        PsiElement parent = resolved.getParent();
        if (parent instanceof PyAssignmentStatement && (value = ((PyAssignmentStatement)parent).getAssignedValue()) instanceof PyCallExpression && (callee = ((PyCallExpression)value).getCallee()) instanceof PyReferenceExpression) {
            PyExpression calleeQualifier = ((PyReferenceExpression)callee).getQualifier();
            if (calleeQualifier != null) {
                value.replace((PsiElement)calleeQualifier);
            } else {
                PyUtil.removeQualifier(element);
            }
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix", "updateArgumentList"));
        }
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            PyExpression argument = arguments[0];
            PyUtil.eraseWhitespaceAndComma(argument.getParent().getNode(), (PsiElement)argument, false);
            argument.delete();
        }
    }
}

