/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.override.PyOverrideImplementUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImplementMethodsQuickFix
implements LocalQuickFix {
    private final PyClass myClass;
    private final Set<PyFunction> myToImplement;

    public PyImplementMethodsQuickFix(PyClass aClass, Set<PyFunction> toBeImplemented) {
        this.myClass = aClass;
        this.myToImplement = toBeImplemented;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.implement.methods", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix", "applyFix"));
        }
        Editor editor = PyImplementMethodsQuickFix.getEditor(project, descriptor.getPsiElement().getContainingFile());
        if (editor != null) {
            PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, this.myClass, this.myToImplement, "Select Methods to Implement", true);
        }
    }

    @Nullable
    private static Editor getEditor(Project project, PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null) {
            EditorFactory instance = EditorFactory.getInstance();
            if (instance == null) {
                return null;
            }
            Editor[] editors = instance.getEditors(document);
            if (editors.length > 0) {
                return editors[0];
            }
        }
        return null;
    }
}

