/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyDefaultArgumentQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.default.argument", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyDefaultArgumentQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyDefaultArgumentQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyDefaultArgumentQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyDefaultArgumentQuickFix", "applyFix"));
        }
        PsiElement defaultValue = descriptor.getPsiElement();
        PyNamedParameter param = (PyNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)defaultValue, PyNamedParameter.class);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)defaultValue, PyFunction.class);
        assert (param != null);
        String defName = param.getName();
        if (function != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            PyStatementList list = function.getStatementList();
            PyParameterList paramList = function.getParameterList();
            StringBuilder functionText = new StringBuilder("def " + function.getName() + "(");
            int size = paramList.getParameters().length;
            for (int i = 0; i != size; ++i) {
                PyParameter p = paramList.getParameters()[i];
                if (p == param) {
                    functionText.append(defName).append("=None");
                } else {
                    functionText.append(p.getText());
                }
                if (i == size - 1) continue;
                functionText.append(", ");
            }
            functionText.append("):\n\tif not ").append(defName).append(":\n\t\t").append(defName).append(" = ").append(defaultValue.getText());
            PyStatement[] statements = list.getStatements();
            PyStatement firstStatement = statements.length > 0 ? statements[0] : null;
            PyFunction newFunction = elementGenerator.createFromText(LanguageLevel.forElement(function), PyFunction.class, functionText.toString());
            if (firstStatement == null) {
                function.replace(newFunction);
            } else {
                PyStatement ifStatement = newFunction.getStatementList().getStatements()[0];
                PyStringLiteralExpression docString = function.getDocStringExpression();
                if (docString != null) {
                    list.addAfter((PsiElement)ifStatement, (PsiElement)firstStatement);
                } else {
                    list.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
                }
                paramList.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(defaultValue), PyFunction.class, functionText.toString()).getParameterList());
            }
        }
    }
}

