/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyCreatePropertyQuickFix
implements LocalQuickFix {
    private final AccessDirection myAccessDirection;

    public PyCreatePropertyQuickFix(AccessDirection dir) {
        this.myAccessDirection = dir;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.create.property", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PyType type;
        PyExpression qualifier;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null && (type = TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile()).getType(qualifier)) instanceof PyClassType) {
            PyClass cls = ((PyClassType)type).getPyClass();
            String propertyName = ((PyQualifiedExpression)element).getName();
            if (propertyName == null) {
                return;
            }
            String fieldName = "_" + propertyName;
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyFunction property = generator.createProperty(LanguageLevel.forElement(cls), propertyName, fieldName, this.myAccessDirection);
            PyUtil.addElementToStatementList(property, cls.getStatementList(), this.myAccessDirection == AccessDirection.READ);
        }
    }
}

